// $Id: BRbWriteNode.h,v 1.9 2002/12/03 03:49:52 yuya Exp $

#if !defined(_BRbWriteNode_h_)
#define _BRbWriteNode_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"
#include "BRbNode.h"
#include "BRbOutputBuffer.h"
#include "BRbStringTable.h"
#include "BRbDebug.h"

////////////////////////////////////////////////////////////////////////////////

class BRbWriteNode : public BRbNode
{

public:
	BRbWriteNode(BRbDebug& debug);
	virtual ~BRbWriteNode();

public:
	virtual void write(NODE* node, BRbOutputBuffer& buffer);

protected:
	virtual void write_header();
	virtual void write_node(NODE* node);
	virtual void write_node_opt(NODE* node);
	virtual void write_byte(byte value);
	virtual void write_word(word value);
	virtual void write_dword(dword value);
	virtual void write_cstr(const char* str);
	virtual void write_cstr(const char* str, word len);
	virtual void write_string(VALUE str);
	virtual void write_id(ID id);
	virtual void write_literal(VALUE obj);
	virtual void write_object(VALUE obj);

protected:
	BRbOutputBuffer m_headbuf;
	BRbOutputBuffer m_stbuf;
	BRbOutputBuffer m_ndbuf;
	BRbStringTable m_strtbl;
	BRbDebug& m_debug;

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
