#! /usr/bin/ruby

#==============================================================================#
# bin/brbrun.rb
# $Id: brbrun.rb,v 1.3 2003/03/06 06:10:04 yuya Exp $
#==============================================================================#

require 'bruby'
require 'getoptlong'

#==============================================================================#
# BRbRunCommand Module
module BRbRunCommand

  def self.main
    options = parse_argv

    if options[:help] || ARGV.size < 1
      print_usage
    end

    inputfile  = ARGV[0]

    $KCODE    = options[:kcode]
    BRb.debug = options[:debug]

    BRb.load(BRb.dumpfile(inputfile), inputfile)
  end

  def self.parse_argv
    parser = GetoptLong.new
    parser.set_options(
      ['--kcode',  '-K', GetoptLong::REQUIRED_ARGUMENT],
      ['--debug',  '-g', GetoptLong::NO_ARGUMENT],
      ['--help',   '-h', GetoptLong::NO_ARGUMENT]
    )

    options = {}
    parser.each_option { |name, argument|
      options[name.sub(/^--/, '').intern] = argument
    }

    options[:kcode] = 'n' if options[:kcode].nil?
    options[:debug] = !!options[:debug]
    options[:help]  = !!options[:help]

    return options
  rescue GetoptLong::InvalidOption
    exit(1)
  end

  def self.print_usage
    STDERR.puts "bRuby #{BRb::VERSION}"
    STDERR.puts "Usage: brbrun.rb [options] file"
    STDERR.puts "Options:"
    STDERR.puts "  -K  --kcode    specifies KANJI code-set."
    STDERR.puts "  -g  --debug    enable debug mode."
    STDERR.puts "  -h  --help     display this information."
    exit(1)
  end

end # BRbRunCommand

#==============================================================================#

BRbRunCommand.main

#==============================================================================#
#==============================================================================#
