#! /usr/bin/ruby -Ks

#==============================================================================#
# test-complex.rb
# $Id: test-complex.rb,v 1.14 2003/03/06 09:07:23 yuya Exp $
#==============================================================================#

require 'testcase'

#==============================================================================#

class ComplexTest < BRbTestCase

  [
    'localvars',
    'strsub',
    'args',
    'args2',
    'module_scope',
    'module_scope2',
    'class_scope',
    'class_scope2',
    'class_class_method',
    'class_instance_method',
    'bignum',
    'bug_report1',
    'bug_report2',
    'bug_report3',
    'bug_report4',
    'bug_report5',
  ].each { |name|
    self.module_eval(<<-EOS)
      def test_#{name}
        rbfile, rbbfile = mkname('#{name}', 'complex/')
        assert(verify(rbfile, rbbfile))
        assert_equal("\n" + exec_ruby(rbfile), "\n" + exec_bruby(rbbfile))
      end
    EOS
  }

end

#==============================================================================#
#==============================================================================#
