
#include "BRbInputBuffer.h"


#define READTYPE(type)                                    \
    can_read(sizeof(type));                               \
    const type value = *((type*)(m_buffer + m_position)); \
    m_position += sizeof(type);                           \
    return value;


BRbInputBuffer::BRbInputBuffer(char* buffer, int length)
{
	initialize(buffer, length);
}

BRbInputBuffer::BRbInputBuffer(VALUE buffer)
{
	initialize(RSTRING(buffer)->ptr, RSTRING(buffer)->len);
}

BRbInputBuffer::~BRbInputBuffer()
{
	if ( m_buffer ) {
		delete[] m_buffer;
	}

	m_position = 0;
	m_length   = 0;
	m_buffer   = 0;
}


byte
BRbInputBuffer::read_byte()
{
	READTYPE(byte);
}

word
BRbInputBuffer::read_word()
{
	READTYPE(word);
}

dword
BRbInputBuffer::read_dword()
{
	READTYPE(dword);
}

void
BRbInputBuffer::read_bytes(void* buffer, int size)
{
	can_read(size);
	::memcpy(buffer, m_buffer + m_position, size);
	m_position += size;
}


void
BRbInputBuffer::initialize(char* buffer, int length)
{
	m_position = 0;
	m_length   = length;
	m_buffer   = new char[m_length];
	memcpy(m_buffer, buffer, m_length);
}

void
BRbInputBuffer::can_read(int size)
{
	if ( m_position + size > m_length ) {
		throw "EOF";
	}
}
