
#include "BRbNode.h"


const BRbNodeName BRbNode::NAMES[] = {
	{NODE_ALIAS,       "NODE_ALIAS"},
	{NODE_AND,         "NODE_AND"},
	{NODE_ARGS,        "NODE_ARGS"},
	{NODE_ARGSCAT,     "NODE_ARGSCAT"},
	{NODE_ARGSPUSH,    "NODE_ARGSPUSH"},
	{NODE_ARRAY,       "NODE_ARRAY"},
	{NODE_ATTRSET,     "NODE_ATTRSET"},
	{NODE_BACK_REF,    "NODE_BACK_REF"},
	{NODE_BEGIN,       "NODE_BEGIN"},
	{NODE_BLOCK,       "NODE_BLOCK"},
	{NODE_BLOCK_ARG,   "NODE_BLOCK_ARG"},
	{NODE_BLOCK_PASS,  "NODE_BLOCK_PASS"},
	{NODE_BMETHOD,     "NODE_BMETHOD"},
	{NODE_BREAK,       "NODE_BREAK"},
	{NODE_CALL,        "NODE_CALL"},
	{NODE_CASE,        "NODE_CASE"},
	{NODE_CDECL,       "NODE_CDECL"},
	{NODE_CFUNC,       "NODE_CFUNC"},
	{NODE_CLASS,       "NODE_CLASS"},
	{NODE_COLON2,      "NODE_COLON2"},
	{NODE_COLON3,      "NODE_COLON3"},
	{NODE_CONST,       "NODE_CONST"},
	{NODE_CREF,        "NODE_CREF"},
	{NODE_CVAR,        "NODE_CVAR"},
	{NODE_CVAR2,       "NODE_CVAR2"},
	{NODE_CVASGN,      "NODE_CVASGN"},
	{NODE_CVDECL,      "NODE_CVDECL"},
	{NODE_DASGN,       "NODE_DASGN"},
	{NODE_DASGN_CURR,  "NODE_DASGN_CURR"},
	{NODE_DEFINED,     "NODE_DEFINED"},
	{NODE_DEFN,        "NODE_DEFN"},
	{NODE_DEFS,        "NODE_DEFS"},
	{NODE_DMETHOD,     "NODE_DMETHOD"},
	{NODE_DOT2,        "NODE_DOT2"},
	{NODE_DOT3,        "NODE_DOT3"},
	{NODE_DREGX,       "NODE_DREGX"},
	{NODE_DREGX_ONCE,  "NODE_DREGX_ONCE"},
	{NODE_DSTR,        "NODE_DSTR"},
	{NODE_DVAR,        "NODE_DVAR"},
	{NODE_DXSTR,       "NODE_DXSTR"},
	{NODE_ENSURE,      "NODE_ENSURE"},
	{NODE_EVSTR,       "NODE_EVSTR"},
	{NODE_FALSE,       "NODE_FALSE"},
	{NODE_FBODY,       "NODE_FBODY"},
	{NODE_FCALL,       "NODE_FCALL"},
	{NODE_FLIP2,       "NODE_FLIP2"},
	{NODE_FLIP3,       "NODE_FLIP3"},
	{NODE_FOR,         "NODE_FOR"},
	{NODE_GASGN,       "NODE_GASGN"},
	{NODE_GVAR,        "NODE_GVAR"},
	{NODE_HASH,        "NODE_HASH"},
	{NODE_IASGN,       "NODE_IASGN"},
	{NODE_IF,          "NODE_IF"},
	{NODE_IFUNC,       "NODE_IFUNC"},
	{NODE_ITER,        "NODE_ITER"},
	{NODE_IVAR,        "NODE_IVAR"},
	{NODE_LASGN,       "NODE_LASGN"},
	{NODE_LAST,        "NODE_LAST"},
	{NODE_LIT,         "NODE_LIT"},
	{NODE_LVAR,        "NODE_LVAR"},
	{NODE_MASGN,       "NODE_MASGN"},
	{NODE_MATCH,       "NODE_MATCH"},
	{NODE_MATCH2,      "NODE_MATCH2"},
	{NODE_MATCH3,      "NODE_MATCH3"},
	{NODE_MEMO,        "NODE_MEMO"},
	{NODE_METHOD,      "NODE_METHOD"},
	{NODE_MODULE,      "NODE_MODULE"},
	{NODE_NEWLINE,     "NODE_NEWLINE"},
	{NODE_NEXT,        "NODE_NEXT"},
	{NODE_NIL,         "NODE_NIL"},
	{NODE_NOT,         "NODE_NOT"},
	{NODE_NTH_REF,     "NODE_NTH_REF"},
	{NODE_OPT_N,       "NODE_OPT_N"},
	{NODE_OP_ASGN1,    "NODE_OP_ASGN1"},
	{NODE_OP_ASGN2,    "NODE_OP_ASGN2"},
	{NODE_OP_ASGN_AND, "NODE_OP_ASGN_AND"},
	{NODE_OP_ASGN_OR,  "NODE_OP_ASGN_OR"},
	{NODE_OR,          "NODE_OR"},
	{NODE_POSTEXE,     "NODE_POSTEXE"},
	{NODE_REDO,        "NODE_REDO"},
	{NODE_RESBODY,     "NODE_RESBODY"},
	{NODE_RESCUE,      "NODE_RESCUE"},
	{NODE_RESTARGS,    "NODE_RESTARGS"},
	{NODE_RETRY,       "NODE_RETRY"},
	{NODE_RETURN,      "NODE_RETURN"},
	{NODE_SCLASS,      "NODE_SCLASS"},
	{NODE_SCOPE,       "NODE_SCOPE"},
	{NODE_SELF,        "NODE_SELF"},
	{NODE_STR,         "NODE_STR"},
	{NODE_SUPER,       "NODE_SUPER"},
	{NODE_TRUE,        "NODE_TRUE"},
	{NODE_UNDEF,       "NODE_UNDEF"},
	{NODE_UNTIL,       "NODE_UNTIL"},
	{NODE_VALIAS,      "NODE_VALIAS"},
	{NODE_VCALL,       "NODE_VCALL"},
	{NODE_WHEN,        "NODE_WHEN"},
	{NODE_WHILE,       "NODE_WHILE"},
	{NODE_XSTR,        "NODE_XSTR"},
	{NODE_YIELD,       "NODE_YIELD"},
	{NODE_ZARRAY,      "NODE_ZARRAY"},
	{NODE_ZSUPER,      "NODE_ZSUPER"},
};


BRbNode::BRbNode()
{
}

BRbNode::~BRbNode()
{
}


const char*
BRbNode::get_node_name(byte type)
{
	for ( int i = 0; i < sizeof(NAMES) / sizeof(BRbNodeName); i++ ) {
		if ( NAMES[i].type == type ) {
			return NAMES[i].name;
		}
	}

	return "Unknown";
}
