#ifndef __BT_FOR_AP_H__
#define __BT_FOR_AP_H__

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define BT_MAX_BUF_LEN	1024

#ifdef BT_STOP_ERROR
#  define dprintf(...)	
#else
#  define dprintf(...)	fprintf(__VA_ARGS__)
#endif

static int bt_exec_system(char *cmd)
{
	if (system(cmd) < 0) {
		dprintf(stderr, "BTRAX: system call failed.\n");
		return -1;
	}
	return 0;
}

static int bt_format_cmd_and_exec(char *fmt, ...)
{
	va_list argp;
	char cmd[BT_MAX_BUF_LEN];
	int len;

	va_start(argp, fmt);
	len = vsnprintf(cmd, BT_MAX_BUF_LEN, fmt, argp);
	va_end(argp);
	if (len == BT_MAX_BUF_LEN) {
		dprintf(stderr, "BTRAX: BT_MAX_BUF_LEN is too short.\n");
		return -1;
	}
	return bt_exec_system(cmd);
}

void bt_start_from_ap(void)
{
	char *outdir, out[BT_MAX_BUF_LEN];
	struct stat st;
	pid_t pid;

	if (stat("/proc/btrax/enable", &st) < 0) {
		dprintf(stderr,
			"BTRAX: btrax not loaded, or permission denied\n");
		return;
	}
	pid = getpid();
	if (!(outdir = getenv("BT_OUTPUT_DIR"))) {
		dprintf(stderr, "BTRAX: can't get 'BT_OUTPUT_DIR' value\n");
		return;
	}
	if (snprintf(out, BT_MAX_BUF_LEN, "%s/%d.maps", outdir, pid)
	    == BT_MAX_BUF_LEN) {
		dprintf(stderr, "BTRAX: BT_MAX_BUF_LEN is too short\n");
		return;
	}
	if (stat(out, &st) < 0) {
		if (bt_format_cmd_and_exec("cp /proc/%d/maps %s", pid, out) < 0)
			return;
	}
	if (bt_format_cmd_and_exec("echo %d > /proc/btrax/pid", pid) < 0)
		return;
	bt_exec_system("echo 1 > /proc/btrax/enable");
}

void bt_stop_from_ap(void)
{
	bt_exec_system("echo 0 > /proc/btrax/enable");
}

#endif /*__BT_FOR_AP_H__*/
