/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_hconv.h - coverage output to html converter header                    */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_HCONV_H__
#define __BT_HCONV_H__

//#define MAX_LINE_LEN	4096

struct html_out_data {
	FILE	*in;
	FILE	*summary_out;
	FILE	*cur_out;
	char	*srcdir;
	char	*outdir;
	char	*name;
	char	abs_path[PATH_MAX + 1];
};

#define BCOV_TYPE_OK	0
#define BCOV_TYPE_UK	1
#define BCOV_TYPE_HT	2
#define BCOV_TYPE_NT	3

int dir_chk_and_create(char *path, int err_on_exists);
int init_html_output(struct html_out_data*);
void out_summary_html_name(struct html_out_data*);

/* function coverage */
void out_summary_html_func(struct html_out_data *dt,
			   long n_func, long n_func_all);
void out_func_html_start(struct html_out_data*);
void out_func_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			unsigned long addr, long cnt);
void out_func_html_end(struct html_out_data*);

/* branch coverage */
void out_summary_html_branch(struct html_out_data *dt,
			     long n_br_ok, long n_br_uk,
			     long n_br_ht, long n_br_nt, long n_br_all);
void out_branch_html_start(struct html_out_data*);
void out_branch_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			  unsigned long base, unsigned long branch, long b_cnt,
			  unsigned long fall, long f_cnt);
void out_branch_html_end(struct html_out_data*);

/* state coverage */
void out_summary_html_state(struct html_out_data *dt, long n_ok, long n_states);
void out_state_html_start(struct html_out_data*);
void out_state_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			 int is_exec, unsigned long);
#define out_state_html_end out_branch_html_end

int exit_html_output(struct html_out_data*);

#endif /*__BT_HCONV_H__*/

