/* 
 djprobe -- Direct jmp-insertion probe
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/rcupdate.h>
#include <linux/sched.h>
#include "djprobe.h"

#define _DEBUG_(a) 
#if 0
#define _DEBUG_(a) a
#endif

static long addr=0; //__switch_to
module_param(addr, long, 0444);
static long size=0;
module_param(size, long, 0444);
static unsigned long(*running)(void);
module_param(running, long, 0444);

static void show_code(long start, long end) 
{
	unsigned char * ptr = (unsigned char *)start;
	printk("Code:%lx:",start);
	while (ptr < (unsigned char *)end) {
		printk("%02x ", (unsigned char )*ptr);
		ptr ++;
	}
	printk("\n");
}

#define CALLER(regs) (((unsigned long *)&regs->esp)[0])
#define ARG(n,regs) (((unsigned long *)&regs->esp)[n]) /*arg1: ARG(1,stadr)*/

static void probe_func(struct djprobe *djp, struct pt_regs *regs)
{
	struct task_struct *prev, *next;
	unsigned long long tsc;
#ifdef CONFIG_REGPARM
	prev = (void*)regs->eax;
	next = (void*)regs->edx;
#else
	prev = ARG(1, regs);
	next = ARG(2, regs);
#endif
	rdtscll(tsc);
	printk("[%llu] context switch:%d(%ld) to %d, nr_running:%ld\n", tsc,
	       prev->pid, prev->state, next->pid, 
	       running());
}

static struct djprobe djp;

static int install_probe(void) 
{
	
	if (addr == 0 || size < 5 || size > 16+5 ||
	    running == 0) {
		return -1;
	}
	show_code(addr, addr+size + 5);
	printk("probe install at %p, size %ld\n", (void*)addr, size);

	djp.addr = (void*)addr;
	djp.size = size;
	djp.handler = probe_func;
	if (register_djprobe(&djp) != 0) return -1;

	show_code(addr, addr+size + 5);
//	show_code((long)&(djp.inst->stub.insn[0]), (long)&(djp.inst->stub.size));
	
	return 0;
}

static void uninstall_probe(void)
{
	show_code(addr, addr+size + 5);
	unregister_djprobe(&djp);
	printk("probe uninstall at %p\n", (void*)addr);
	show_code(addr, addr+size + 5);
}

module_init(install_probe);
module_exit(uninstall_probe);
MODULE_AUTHOR("M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_LICENSE("GPL");

