/*
 * Crackerjack Project
 *
 * Copyright (C) 2007-2008, Hitachi, Ltd.
 * Author(s): Yumiko Sugita <yumiko.sugita.yf@hitachi.com>,
 *            Satoshi Fujiwara <sa-fuji@sdl.hitachi.co.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Id:$
 *
 */
#include "../../common.j.h/include_j_h.h"

#ifndef __CJK_SYSCALL_SOCKETCALL__
#define __CJK_SYSCALL_SOCKETCALL__

/*
 * Definitions
 */
#define MAX_SOCK_TESTCASES	32

enum sv_control {
	SV_NORMAL,
	SV_NOT_RESPONSE,
	SV_SLOW_RESPONSE,
	SV_DISCONN_BY_ACCEPT,
	SV_SEND_SIGINT_BY_ACCEPT,
	SV_DISCONN_BY_RECV,
	SV_SEND_SIGINT_BY_RECV,
};

enum cl_control {
	CL_NORMAL,
	CL_SEND_SIGINT,
};

pid_t
create_server_proc(int type, int protocol, struct sockaddr *addr, socklen_t len,
		   int control);
pid_t
create_client_proc(int type, int protocol, struct sockaddr *addr, socklen_t len,
		   int control);

#endif /* __CJK_SYSCALL_SOCKETCALL__ */
