/*
  $Id: getdate.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $
*/
#if !defined(__GET_DATE_H__)
#define __GET_DATE_H__

#include <sys/timeb.h>

#if defined(__cplusplus)
#include <ctime>
#include <string>
#include <boost/call_traits.hpp>
namespace date {
  extern "C" time_t get_date(char const* p, timeb* now = 0);

  inline
  std::string date2str(boost::call_traits<time_t>::param_type t)
  {
    struct tm gmtm;
    gmtime_r(&t, &gmtm);
    char tmp[128];
    std::strftime(tmp, 127, "%F %T utc", &gmtm);
    return std::string(tmp);
  }

}
#else
#include <time.h>
extern time_t get_date(char const* p, struct timeb* now);
#endif


#endif
