// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: BugItem.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__BUGITEM_H__)
#define __BUGXEE__BUGITEM_H__

#include <string>
#include <list>
#include <set>

#include <libxml/tree.h>

/**
   @namespace namespace of bugxee.
 */
namespace bugxee {

  class Repository;

  class BugItem
  {
  public:
    Repository* repository_;
    int bugno_;

    class Jornal_t
    {
    public:
      long timestamp_;
      std::string userName_;
      std::string userMailAddress_;
      std::string status_;
      std::string maintener_;
      unsigned int priority_; ///< Must be zero if no priority changed.
      std::string addedCategory_;
      std::string removedCategory_;
      std::string subject_;
      std::string message_;

      inline Jornal_t() { clear(); }

      void clear();
      void stamp();
    };
    typedef std::list<Jornal_t> JornalList;

  protected:
    JornalList jornals_;
    bool modified_;

    void loadFromFile(char const* path);

  public:
    BugItem(Repository* repository, int bugno)
      : repository_(repository), bugno_(bugno) { }
    virtual ~BugItem();

    int bugno() const { return bugno_; }
    Repository* repository() const { return repository_; }
    bool isModified() const { return modified_; }


    //@{ @name Access to bug summary.
    std::string const& subject() const;
    std::string const& maintener() const;
    std::string const& status() const;
    unsigned int priority() const;
    time_t lastModified() const;
    void enumCategories(std::set<std::string>* dst) const;
    //@}

    //@{ @name record to jornal
    Jornal_t const& changeSubject(char const* subject);
    Jornal_t const& appendMessage(char const* message);
    Jornal_t const& appendJornal(Jornal_t const& src);
    //@}

    //@{ @name Access to each jornal via iterator
    /// Get iterator points a first jornal entry of this bug.
    /// @returns Iterator points first jornal.
    JornalList::iterator jornal_begin() { return jornals_.begin(); }
    /// Get iterator points a tail of jornal of this bug.
    /// @returns Iterator points tail of jornal.
    JornalList::iterator jornal_end() { return jornals_.end(); }

    /// Get const iterator oints a first jornal entry of hits bug.
    /// @returns Iterator points first jornal
    JornalList::const_iterator jornal_end() const { return jornals_.end(); }
    /// Get iterator points a tail of jornal of this bug.
    /// @returns Iterator points tail of jornal.
    JornalList::const_iterator jornal_begin() const { return jornals_.begin(); }
    //@}

    virtual void load() = 0;
    virtual void save() = 0;
    void saveToFile(char const* path) const;
    void saveToStream(std::ostream& ost) const;
    xmlNodePtr toDOMTree(xmlNodePtr parent = NULL) const;
  };
}

#endif


