// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: Exception.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "common.h"

#include <cstdlib>
#include <cerrno>

#include "Exception.h"

namespace bugxee {

  OSError::OSError(char const* msg)
    : std::runtime_error(std::string(msg) + " : " + std::strerror(errno)),
      error_(errno)
  {
  }

  OSError::OSError(std::string const& msg)
    : std::runtime_error(msg + " : " + std::strerror(errno)),
      error_(errno)
  {
  }


  UnknownOptionError::UnknownOptionError(char const* opt)
    : std::invalid_argument(std::string(_("Unknown option : ")) + opt)
  {
  }


  InvalidOptionValue::InvalidOptionValue(char const* opt)
    : std::invalid_argument(std::string(_("Invalud option : ")) + opt)
  {
  }


  UnknownBugNo::UnknownBugNo(int bugno)
    : std::invalid_argument(_("Unknown BUG#"))
  {
//    char tmp[10];
//    std::sprintf(tmp, " %04d", bugno);
//    _M_msg.append(tmp);
  }

}
