// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: Exception.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__EXCEPTION_H__)
#define __BUGXEE__EXCEPTION_H__

#include <exception>
#include <stdexcept>
#include <iostream>
#include <cstring>
#include <boost/utility.hpp>


namespace bugxee {

  class OSError : public std::runtime_error
  {
  protected:
    int error_;

  public:
    OSError(char const* msg);
    OSError(std::string const& msg);

    inline int errorno() const { return error_; }
  };


  class UnknownOptionError
    : public std::invalid_argument
  {
  public:
    UnknownOptionError(char const* opt);
  };


  class InvalidOptionValue
    : public std::invalid_argument
  {
  public:
    InvalidOptionValue(char const* opt);
  };

  class UnknownBugNo
    : public std::invalid_argument
  {
  public:
    UnknownBugNo(int bugno);
  };
}

inline void OS_VERIFY(int b, char const* msg = NULL) throw(bugxee::OSError)
{
  if (b < 0)
    throw bugxee::OSError((msg == NULL)? "" : msg);
}

#endif
