// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: LocalRepository.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__LOCALREPOSITORY_H__)
#define __BUGXEE__LOCALREPOSITORY_H__

#include <string>
#include <stdexcept>
#include <ctime>

#include "Exception.h"
#include "BugItem.h"
#include "Repository.h"
#include "Summary.h"

namespace bugxee {

  class LocalRepository : public Repository
  {
  protected:
    class LocalBugItem : public BugItem
    {
    public:
      LocalBugItem(LocalRepository* repository, int bugno)
        : BugItem(repository, bugno)
      {
      }

      virtual void load();
      virtual void save();
    };

  protected:
    std::string dir_;
    int nextBugno_;
    bool stateModified_;

  protected:
    std::string bugno2filename(int bugno) const;
    virtual void loadTitle() const;

    void loadConfig() throw(std::runtime_error);
    void saveConfig() throw(std::runtime_error);

    void loadState() throw(std::runtime_error);
    void saveState() throw(OSError);

    virtual Index_t& loadIndex(char const* domain, char const* name);
    virtual void saveIndex(char const* domain, char const* name);

    virtual BugItem* loadBug(int bugno);

    int assignBugno();

    std::string summaryPath(time_t timestamp) const;
    void recordSummary(time_t timestamp, int bugno,
                       Summary::Entry_t::Action_t action, std::string const& text) const;

  public:
    LocalRepository(char const* dir)
      : dir_(dir),
        stateModified_(false)
    {
    }

    std::string const& dir() const { return dir_; }

    void open() throw(std::runtime_error);
    virtual void lock_impl() const;
    virtual void unlock_impl() const;

    virtual void initialize();

    virtual BugItem* addBug(char const* subject, char const* message);
    virtual void changeSubject(int bugno, char const* subject);
    virtual void addMessage(int bugno, char const* message);
    virtual void addJornal(int bugno, BugItem::Jornal_t const& jornal);
    virtual void joinMaintener(char const* maintener);
    virtual void addCategory(std::string const& category);

    virtual void commit();

  };


}

#endif


