// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Module for abstract repository class.

   @author seagull
   @version "$Id: Message.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "common.h"

#include "charsets.h"
#include "Message.h"

namespace bugxee {

  /**
     Default constractor.
   */
  Message::Message()
  {
  }

  /**
     Constract with source text.
     @param source Source message text
   */
  Message::Message(char const* source)
  {
    parse(source);
  }

  /**
     Constract with subject and body
     @param subject Subject string.
     @param body Body text.
   */
  Message::Message(char const* subject, char const* body)
    : subject_(subject),
      body_(body)
  {
  }

  /**
     Constract with subject and body
     @param subject Subject string.
     @param body Body text.
   */
  Message::Message(std::string const& subject, std::string const& body)
    : subject_(subject),
      body_(body)
  {
  }

  /**
     Parse source text
     @param source Source text
   */
  void
  Message::parse(char const* source)
  {
    subject_.clear();
    body_.clear();

    char const* p = source;
    while (*p && *p == '\n')
      p++;
    if (! *p)
      return ;
    char const* subj = p;
    while (*p && *p != '\n')
      p++;
    subject_.assign(subj, p - subj);

    if (*p)
      while (*p && *p == '\n')
        p++;
    if (! *p)
      return;
    char const* msg = p;
    char const* pp = NULL;
    while (*p)
      {
        if (*p != '\n')
          pp = p;
        p++;
      }

    if (pp == NULL)
      body_.clear();
    else
      body_.assign(msg, (pp + 1) - msg);
  }

  /**
   */
  void
  Message::parseWithLocalEncoding(char const* source)
  {
    std::string utfstr = toUTF8(source);
    parse(utfstr.c_str());
  }

}
