// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: Message.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__MESSAGE_H__)
#define __BUGXEE__MESSAGE_H__

#include <string>

namespace bugxee {

  class Message
  {
  protected:
    std::string subject_;
    std::string body_;

  public:
    Message();
    Message(char const* source);
    Message(char const* subject, char const* body);
    Message(std::string const& subject, std::string const& body);

    std::string const& subject() const { return subject_; }
    std::string& subject() { return subject_; }
    std::string const& body() const { return body_; }
    std::string& body() { return body_; }

    void parse(char const* source);
    void parseWithLocalEncoding(char const* source);

    bool isValid() const
    {
      return ! subject_.empty() && ! body_.empty();
    }
  };

}


#endif
