// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Abstract outputter and factory module.

   @author seagull
   @version "$Id: Outputter.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#include "common.h"
#include <stdexcept>
#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif

#include "Exception.h"
#include "Outputter.h"
#include "Outputter/XMLOutputter.h"
#include "Outputter/TextOutputter.h"


namespace bugxee {

  void
  AbstractOutputterFactory::registerAllOutputter()
  {
    FactoryPool& pool = factories();

    static ConcreteOutputterFactory<XMLOutputter> xmlFactory("xml");
    static ConcreteOutputterFactory<TextOutputter> textFactory("text");
    pool["xml"] = &xmlFactory;
    pool["text"] = &textFactory;
  }


  AbstractOutputter::AbstractOutputter(std::ostream& ost)
    : ost_(ost)
  {
    totalCount_ = 0;
    outputCount_ = 0;

    struct timeval tv;
    struct timezone tz;
    OS_VERIFY(::gettimeofday(&tv, &tz));
    timestamp_ = tv.tv_sec; // + tz.tz_minuteswest * 60;
  }


  AbstractOutputter::~AbstractOutputter()
  {
  }



  AbstractOutputterFactory::AbstractOutputterFactory(char const* name)
  {
    name_ = name;
  }

  AbstractOutputterFactory::~AbstractOutputterFactory()
  {
  }


  AbstractOutputterFactory::FactoryPool&
  AbstractOutputterFactory::factories()
  {
    static FactoryPool pool;
    return pool;
  }


  AbstractOutputterFactory const*
  AbstractOutputterFactory::findByName(std::string const& name)
  {
    FactoryPool::iterator i = factories().find(name);
    if (i == factories().end())
      return NULL;
    return i->second;
  }


  std::auto_ptr<AbstractOutputter>
  AbstractOutputterFactory::create(std::string const& name, std::ostream& ost)
  {
    AbstractOutputterFactory const* factory = findByName(name);
    if (! factory)
      throw std::runtime_error(_("Unknown factory"));
    return factory->create(ost);
  }

}



