// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: Outputter.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__OUTPUTTER_H__)
#define __BUGXEE__OUTPUTTER_H__

#include <map>
#include <string>
#include <ostream>
#include <memory>
#include <stdexcept>
#include <ctime>

#include "BugItem.h"

namespace bugxee {


  /**
   */
  class AbstractOutputter
  {
  protected:
    std::ostream& ost_;

    unsigned int totalCount_;
    unsigned int outputCount_;

    time_t timestamp_;

  public:
    AbstractOutputter(std::ostream& ost);
    virtual ~AbstractOutputter();

    virtual void start() = 0;
    virtual void finish() = 0;

    //@{ @name for post
    virtual void writeNewBug(BugItem const* bug) = 0;
    //@}

    //@{ @name for detail output
    virtual void writeDetail(BugItem const* bug) = 0;
    //@}

    //@{ @name for list output
    void setTotalCount(unsigned int count) { totalCount_ = count; }
    unsigned int totalCount() const { return totalCount_; }
    unsigned int outputCount() const { return outputCount_; }
    virtual void writeConditionOfPriority(int priority) = 0;
    virtual void writeConditionOfMaintener(std::string const& name) = 0;
    virtual void writeConditionOfCategory(std::string const& category) = 0;
    virtual void beginGroup(std::string const& desc) = 0;
    virtual void finishGroup() = 0;
    virtual void writeList(BugItem const* bug) = 0;
    //@}


    //@{ @name for summary output
    virtual void writeStatByStatus(std::string const& name, int count) = 0;
    virtual void writeStatByPriority(int priority, int count) =0 ;
    virtual void writeStatTotal(int total) = 0 ;
    //@}
  };



  class AbstractOutputterFactory
  {
  public:
    typedef std::map<std::string, AbstractOutputterFactory const*> FactoryPool;
  protected:
    char const* name_;

  public:
    AbstractOutputterFactory(char const* name);
    virtual ~AbstractOutputterFactory();

    virtual std::auto_ptr<AbstractOutputter> create(std::ostream& ost) const = 0;

    static AbstractOutputterFactory const* findByName(std::string const& name);

    static void registerAllOutputter();
    static FactoryPool& factories();

    static std::auto_ptr<AbstractOutputter> create(std::string const&  name, std::ostream& ost);
  };



  template <typename PRODUCT>
  class ConcreteOutputterFactory
    : public AbstractOutputterFactory
  {
  public:
    ConcreteOutputterFactory(char const*name)
      : AbstractOutputterFactory(name)
    { }

    virtual std::auto_ptr<AbstractOutputter> create(std::ostream& ost) const
    {
      return std::auto_ptr<AbstractOutputter>(new PRODUCT(ost));
    }
  };


}

#endif
