// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: TextOutputter.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#include "../common.h"

#include <ostream>
#include <iomanip>

#include "../../lib/getdate.h"
#include "../charsets.h"
#include "TextOutputter.h"

namespace bugxee {

  TextOutputter::TextOutputter(std::ostream& ost)
    : AbstractOutputter(ost)
  {
  }


  void
  TextOutputter::start()
  {
  }


  void
  TextOutputter::finish()
  {
    ost_
      << "Total " << outputCount_ << " bugs listed in " << totalCount_ << "." << std::endl;
  }


  void
  TextOutputter::writeNewBug(BugItem const* bug)
  {
    ost_ << "Added new bug as BUG#" << bug->bugno() << std::endl;
  }

  void
  TextOutputter::writeDetail(BugItem const* bug)
  {
    ost_ 
      << std::setfill('=') << std::right << std::setw(75) << "\n"
      << _("BUG#") << std::setfill('0') << std::setw(4) << bug->bugno() << " "
      << fromUTF8(bug->subject()) << "\n";

    for (BugItem::JornalList::const_iterator j = bug->jornal_begin();
         j != bug->jornal_end(); j++)
      {
        ost_
          << std::setfill('-') << std::right << std::setw(75) << "\n"
          << _("From: ") << fromUTF8(j->userName_) << " <" << fromUTF8(j->userMailAddress_) << ">\n"
          << _("Date: ") << date::date2str(j->timestamp_) << '\n';
        if (! j->subject_.empty())
          ost_ << _("Subject: ") << fromUTF8(j->subject_) << "\n";
        if (! j->status_.empty())
          ost_ << _("X-bugxee-status-changed: ") << fromUTF8(j->status_) << "\n";
        if (! j->maintener_.empty())
          ost_ << _("X-bugxee-maintener: ") << fromUTF8(j->maintener_) <<"\n";
        if (j->priority_)
          ost_ << _("X-bugxee-priority-change: ") << j->priority_ << "\n";
        if (! j->addedCategory_.empty())
          ost_ << _("X-bugxee-category-added: ") << fromUTF8(j->addedCategory_) << "\n";
        if (! j->removedCategory_.empty())
          ost_ << _("X-bugxee-category-removed: ") << fromUTF8(j->removedCategory_) << "\n";
        if (! j->message_.empty())
          ost_ << "\n"
               <<fromUTF8(j->message_) << "\n";
        ost_ << std::endl;
      }

    outputCount_++;
  }

  /**
  */
  void
  TextOutputter::beginGroup(std::string const& desc)
  {
    ost_
      << "\n\n"
      << "Group: " << desc << '\n'
      << std::left << std::setfill(' ')
      << std::setw(4) << _("BUG#") << " "
      << _("P ")
      << std::setw(53) << _("SUBJECT")
      //      << ' ' << std::setw(10) << _("  STATUS  ") << ' '
      << ' ' << std::setw(10) << _(" MAINTENER") << ' '
      << std::endl
      << std::setfill('-') << std::setw(85) << ""
      << std::endl;
  }

  /**
  */
  void
  TextOutputter::finishGroup()
  {
    ost_
      << std::setfill('-') << std::setw(85) << ""
      << std::endl;
  }

  void
  TextOutputter::writeList(BugItem const* bug)
  {
    ost_ << std::right
         << std::setw(4) << std::setprecision(0) << std::setfill('0')
         << bug->bugno() << ' '
         << bug->priority() << ' '
         << std::left
         << std::setw(53) << std::setfill(' ')  << fromUTF8(bug->subject())
         << " "
      //         << '[' << std::setw(10) << std::setfill(' ')  << fromUTF8(bug->status()) << ']'
         << '[' << std::setw(10) << std::setfill(' ')  << fromUTF8(bug->maintener()) << ']'
         << ' ' << date::date2str(bug->lastModified())
         << std::endl;

    outputCount_++;
  }


  void
  TextOutputter::writeStatByStatus(std::string const& name, int count)
  {
  }

  void
  TextOutputter::writeStatByPriority(int priority, int count)
  {
  }

  
  void
  TextOutputter::writeStatTotal(int total)
  {
  }


  void 
  TextOutputter::writeConditionOfPriority(int priority)
  {
  }


  void
  TextOutputter::writeConditionOfMaintener(std::string const& name)
  {
  }


  void
  TextOutputter::writeConditionOfCategory(std::string const& category)
  {
  }
}



