// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: XMLOutputter.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#include "../common.h"

#include "../../lib/getdate.h"
#include "../XMLHelper.h"
#include "XMLOutputter.h"

namespace bugxee {


  XMLOutputter::XMLOutputter(std::ostream& ost)
    : AbstractOutputter(ost)
  {
    doc_ = XML::newDoc();
    root_ = xmlNewDocNode(doc_, NULL, (xmlChar const*)"bugxee-output", NULL);
    ::xmlDocSetRootElement(doc_, root_);

    char tmp[100];
    std::sprintf(tmp, "%ld", timestamp_);

    detailNode_ = NULL;
    listNode_ = NULL;
    statNode_ = NULL;
  }


  XMLOutputter::~XMLOutputter()
  {
    ::xmlFreeDoc(doc_);
  }


  void
  XMLOutputter::start()
  {
  }


  void
  XMLOutputter::finish()
  {
    ost_ << doc_;
  }



  void
  XMLOutputter::writeNewBug(BugItem const* bug)
  {
    xmlNodePtr node = XML::NewChild(root_, NULL, "new-bug", NULL);
    char strbugno[10];
    std::sprintf(strbugno, "%04d", bug->bugno());
    XML::SetProp(node, "bugno", strbugno);
  }

  void
  XMLOutputter::writeDetail(BugItem const* bug)
  {
    if (detailNode_ == NULL)
      detailNode_ = XML::NewChild(root_, NULL, "details", NULL);

    xmlNodePtr node = bug->toDOMTree(detailNode_);


    {
      std::string const& maintener = bug->maintener();
      if (! maintener.empty())
        XML::SetProp(node, "maintener", maintener.c_str());
    }
    XML::SetProp(node, "status", bug->status().c_str());
    char priority[10];
    std::sprintf(priority, "%d", bug->priority());
    XML::SetProp(node, "priority", priority);

    std::set<std::string> categories;
    bug->enumCategories(&categories);
    for (std::set<std::string>::const_iterator i = categories.begin();
         i != categories.end(); i++)
      XML::NewTextChild(node, NULL, "category", i->c_str());
  }



  void
  XMLOutputter::writeConditionOfPriority(int priority)
  {
    char tmp[10]; sprintf(tmp, "%d", priority);
    xmlNodePtr node = XML::NewChild(root_, NULL, "condition", NULL);
    XML::SetProp(node, "priority", tmp);
  }

  void
  XMLOutputter::writeConditionOfMaintener(std::string const& name)
  {
    xmlNodePtr node = XML::NewChild(root_, NULL, "condition", NULL);
    XML::SetProp(node, "maintener", name);
  }


  void
  XMLOutputter::writeConditionOfCategory(std::string const& category)
  {
    xmlNodePtr node = XML::NewChild(root_, NULL, "condition", NULL);
    XML::SetProp(node, "category", category);
  }


  /**
  */
  void
  XMLOutputter::beginGroup(std::string const& desc)
  {
    listNode_ = XML::NewChild(root_, NULL, "list", NULL);

    char tmp[10];
    std::sprintf(tmp, "%d", totalCount());
    XML::SetProp(listNode_, "total-count", tmp);
    XML::SetProp(listNode_, "status", desc);
  }


  /**
  */
  void
  XMLOutputter::finishGroup()
  {
  }


  /**
  */
  void
  XMLOutputter::writeList(BugItem const* bug)
  {

    char strbugno[10];
    std::sprintf(strbugno, "%04d", bug->bugno());
    char strpriority[10];
    std::sprintf(strpriority, "%d", bug->priority());
 
    xmlNodePtr node = XML::NewChild(listNode_, NULL, "bug-item", NULL);
    XML::SetProp(node, "bugno", strbugno);
    XML::SetProp(node, "last-modified", date::date2str(bug->lastModified()));
    XML::SetProp(node, "priority", strpriority);
    XML::SetProp(node, "subject", bug->subject());
    //    XML::SetProp(node, "status", bug->status());
    XML::SetProp(node, "maintener", bug->maintener());

    std::set<std::string> cat;
    bug->enumCategories(&cat);
    for (std::set<std::string>::iterator i = cat.begin(); i != cat.end(); i++)
      {
        xmlNodePtr catnode = XML::NewChild(node, NULL, "category", NULL);
        XML::SetProp(catnode, "name", *i);
      }
    outputCount_++;
  }

  void
  XMLOutputter::writeStatByStatus(std::string const& name, int count)
  {
    if (statNode_ == NULL)
      statNode_ = XML::NewChild(root_, NULL, "stat", NULL);

    xmlNodePtr node = XML::NewChild(statNode_, NULL, "by-status", NULL);
    XML::SetProp(node, "name", name);
    char tmp[10];
    std::sprintf(tmp, "%d", count);
    XML::SetProp(node, "count", tmp);
  }

  void
  XMLOutputter::writeStatByPriority(int priority, int count)
  {
    if (statNode_ == NULL)
      statNode_ = XML::NewChild(root_, NULL, "stat", NULL);

    xmlNodePtr node = XML::NewChild(statNode_, NULL, "by-priority", NULL);
    char tmp[10];
    std::sprintf(tmp, "%d", priority);
    XML::SetProp(node, "priority", tmp);
    std::sprintf(tmp, "%d", count);
    XML::SetProp(node, "count", tmp);
  }

  
  void
  XMLOutputter::writeStatTotal(int total)
  {
    if (statNode_ == NULL)
      statNode_ = XML::NewChild(root_, NULL, "stat", NULL);

    char tmp[10];
    std::sprintf(tmp, "%d", total);
    XML::SetProp(statNode_, "count", tmp);
  }




}



