// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief
   @version "$Id: XMLOutputter.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__OUTPUTTER__XMLOUTPUTTER_H__)
#define __BUGXEE__OUTPUTTER__XMLOUTPUTTER_H__

#include "../Outputter.h"
#include "../XMLHelper.h"

namespace bugxee {

  class XMLOutputter
    : public AbstractOutputter
  {
  protected:
    xmlDocPtr doc_;
    xmlNodePtr root_;
    xmlNodePtr detailNode_;
    xmlNodePtr listNode_;
    xmlNodePtr statNode_;

  public:
    XMLOutputter(std::ostream& ost);
    ~XMLOutputter();

    virtual void start();
    virtual void finish();

    virtual void writeNewBug(BugItem const* bug);
    virtual void writeConditionOfPriority(int priority);
    virtual void writeConditionOfMaintener(std::string const& name);
    virtual void writeConditionOfCategory(std::string const& category);
    virtual void writeDetail(BugItem const* bug);
    virtual void beginGroup(std::string const& desc);
    virtual void finishGroup();
    virtual void writeList(BugItem const* bug);
    virtual void writeStatByStatus(std::string const& name, int count);
    virtual void writeStatByPriority(int priority, int count);
    virtual void writeStatTotal(int total);
  };


}

#endif
