// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Preferences

   @author seagull
   @version "$Id: Preferences.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#if !defined(__BUGXEE__PREFERENCES_H__)
#define __BUGXEE__PREFERENCES_H__

#include <string>
#include <boost/utility.hpp>

namespace bugxee {

  class Preferences :
    public boost::noncopyable
  {
  public:
  protected:
    bool loaded_;
    std::string repository_;
    std::string userName_;
    std::string userMailAddress_;
    std::string localCharset_;

    std::string outputFormat_;
    std::string editor_;

    Preferences();
    ~Preferences();

    void load(char const* dir);

  public:
    static Preferences& instance();

    void parseOptions(int* argc, char* argv[]);

    inline bool isLoaded() const { return loaded_; }
    inline std::string const& repository() const { return repository_; }
    inline std::string const& userName() const { return userName_; }
    inline std::string const& userMailAddress() const { return userMailAddress_; }
    std::string localCharset() const;
    std::string const& editor() const;
    std::string const& outputFormat() const { return outputFormat_; }
  };

}

std::ostream&
operator <<(std::ostream& ost, bugxee::Preferences const& pref);

#endif
