// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Summary file access module.

   @author seagull
   @version "$Id: Summary.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__SUMMARY_H__)
#define __BUGXEE__SUMMARY_H__

#include <ctime>
#include <list>
#include <boost/utility.hpp>

namespace bugxee {

  /**
     
   */
  class Summary
    : public boost::noncopyable
  {
  public:
    struct Entry_t
    {
      time_t timestamp_;
      int bugno_;
      enum Action_t {
        CREATE = 0,
        MESSAGE,
        ASSIGN,
        STATUS_CHANGE,
        SUBJECT,
        PRIORITY_CHANGE,
        ADD_CATEGORY, DEL_CATEGORY,
        NUM_ACTIONS
      };
      std::string userName_;
      std::string userMailAddress_;
      Action_t action_;
      std::string text_;
    };
  typedef std::list<Entry_t> Entries_t;

  protected:
    Entries_t entries_;
    static char const* entryNames[];

  public:
    Summary();
    void loadFromFile(char const* filename);
    void saveToStream(std::ostream& ost);
    void append(time_t timestamp, int bugno, Entry_t::Action_t action, std::string const& text);
  };


}


#endif
