// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief XML helper module

   @author seagull
   @version "$Id: XMLHelper.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#include "common.h"

#include "XMLHelper.h"

namespace bugxee {
  namespace XML {

    namespace {
      xmlEntityPtr
      globalGetEntity(void* ctxt, xmlChar const* name)
      {
        return ::xmlGetPredefinedEntity(name);
      }
    }

    ::xmlParserCtxtPtr
    initSAXHandler(::xmlSAXHandler* handler,
                   char const* path,
                   void* userData) throw(std::runtime_error)
    {
      ::xmlSubstituteEntitiesDefault(true);

      ::xmlParserCtxtPtr ctxt = xmlCreateFileParserCtxt(path);
      if (! ctxt)
        throw std::runtime_error(_("file could not load."));

      handler->internalSubset = NULL;
      handler->isStandalone = NULL;
      handler->hasInternalSubset = NULL;
      handler->hasExternalSubset = NULL;
      handler->resolveEntity = NULL;
      handler->getEntity = globalGetEntity;
      handler->entityDecl = NULL;
      handler->notationDecl = NULL;
      handler->attributeDecl = NULL;
      handler->elementDecl = NULL;
      handler->unparsedEntityDecl = NULL;
      handler->setDocumentLocator = NULL;
      handler->startDocument = NULL;
      handler->endDocument = NULL;
      handler->startElement = NULL;
      handler->endElement = NULL;
      handler->reference = NULL;
      handler->characters = NULL;
      handler->ignorableWhitespace = NULL;
      handler->processingInstruction = NULL;
      handler->comment = NULL;
      handler->warning = NULL;
      handler->error = NULL;
      handler->fatalError = NULL;
      handler->getParameterEntity = globalGetEntity;
      handler->cdataBlock = NULL;
      handler->externalSubset = NULL;
      handler->initialized = 0;

      ctxt->sax = handler;
      ctxt->userData = userData;
      return ctxt;
    }


  }
}


std::ostream&
operator <<(std::ostream& ost, xmlDocPtr doc)
{
  struct context_t
  {
    std::ostream& ost_;
    context_t(std::ostream& ost) : ost_(ost) { }
    static int iowrite(context_t* ctxt, char const* buff, int len)
    { ctxt->ost_.write(buff, len); return len; }
  } context(ost);
  ::xmlOutputBufferPtr obuff =
      xmlOutputBufferCreateIO((xmlOutputWriteCallback)context_t::iowrite,
                             NULL, (void*)&context, NULL);
  ::xmlSaveFileTo(obuff, doc, "UTF-8");
  //  ::xmlFree(obuff);

  return ost;
}
