// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief XML helper module

   @author seagull
   @version "$Id: XMLHelper.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#if !defined(__BUGXEE__XMLHELPER_H__)
#define __BUGXEE__XMLHELPER_H__

#include <ostream>
#include <stdexcept>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>

namespace bugxee {
  namespace XML {

    ::xmlParserCtxtPtr
    initSAXHandler(::xmlSAXHandler* handler,
                   char const* path,
                   void* userData) throw(std::runtime_error);

    inline
    xmlDocPtr newDoc(char const* ver = "1.0") { return ::xmlNewDoc((xmlChar const*)ver); }

    inline
    xmlNodePtr NewChild(xmlNodePtr node,
                        xmlNsPtr ns, char const* name,
                        char const* content)
    {
      return ::xmlNewChild(node, ns, (xmlChar const*)name, (xmlChar const*)content);
    }

    inline
    xmlNodePtr NewChild(xmlNodePtr node,
                        xmlNsPtr ns, char const* name,
                        std::string const& content)
    {
      return NewChild(node, ns, name, content.c_str());
    }


    inline
    xmlNodePtr NewTextChild(xmlNodePtr node,
                            xmlNsPtr ns, char const* name,
                            char const* content)
    {
      return ::xmlNewTextChild(node, ns, (xmlChar const*)name, (xmlChar const*)content);
    }

    inline
    xmlNodePtr NewTextChild(xmlNodePtr node,
                            xmlNsPtr ns, char const* name,
                            std::string const& content)
    {
      return NewTextChild(node, ns, name, content.c_str());
    }


    inline
    xmlNodePtr NewNode(xmlNsPtr ns, char const* name)
    {
      return ::xmlNewNode(ns, (xmlChar const*)name);
    }
    inline
    xmlNodePtr NewNode(xmlNsPtr ns, std::string const& name)
    {
      return NewNode(ns, name.c_str());
    }

    inline
    xmlAttrPtr SetProp(xmlNodePtr node, char const* name, char const* value)
    {
      return ::xmlSetProp(node, (xmlChar const*)name, (xmlChar const*)value);
    }
    inline
    xmlAttrPtr SetProp(xmlNodePtr node, char const* name, std::string const& value)
    {
      return SetProp(node, name, value.c_str());
    }


  }
}

std::ostream&
operator <<(std::ostream& ost, xmlDocPtr doc);

#endif



