// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @version "$Id: charsets.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "common.h"

#include <iostream>
#include <iconv.h>
#include <cstdlib>
#include <string>

#include "Preferences.h"
#include "log.h"
#include "charsets.h"

namespace bugxee {

  namespace {
    std::string doConvert(::iconv_t icv, char const* src) throw(OSError)
    {
      std::string utfmsg;
      try
        {
          size_t inplen = std::strlen(src);
          while (inplen > 0)
            {
              char tmp[1024];
              char* outp = tmp;
              size_t outlen = 1024;
              size_t result = ::iconv(icv, (char ICONV_CONST**)&src, &inplen, &outp, &outlen);
              if (result == size_t(-1) && errno != E2BIG)
                {
                  throw OSError("iconv");
                }
              utfmsg.append(tmp, 1024 - outlen);
              if (result && result != size_t(-1))
                log.warn(_("iconv returns %d."), result);
            }
        }
      catch (std::exception& e)
        {
          ::iconv_close(icv);
          throw;
        }
      ::iconv_close(icv);
      utfmsg.append("");  // force terminate.
      return utfmsg;
    }
  }


  /**
     Conversion string from UTF-8 to current locale specific.
     @param src Source UTF-8 string.
     @returns locale specific string.
   */
  std::string fromUTF8(char const* src) throw(OSError)
  {
    std::string cset = Preferences::instance().localCharset();
    return doConvert(::iconv_open(cset.c_str(), "UTF-8"), src);
  }




  /**
     Conversion string from locale specific to UTF-8
     @param src Locale specific string
     @returns UTF-8 string.
  */
  std::string toUTF8(char const* src) throw(OSError)
  {
    std::string cset = Preferences::instance().localCharset();
    return doConvert(::iconv_open("UTF-8", cset.c_str()), src);
  }

}



