// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @version $Id: charsets.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $
 */

#if !defined(__BUGXEE__CHARSETS_H__)
#define __BUGXEE__CHARSETS_H__

#include <string>
#include "Exception.h"

namespace bugxee {

  extern std::string fromUTF8(char const* src) throw (OSError);
  extern std::string toUTF8(char const* src) throw (OSError);

  inline std::string fromUTF8(std::string const& src) throw (OSError)
  {
    return fromUTF8(src.c_str());
  }
  inline std::string toUTF8(std::string const& src) throw (OSError)
  {
    return toUTF8(src.c_str());
  }

}

#endif
