// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: command.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "common.h"

#include <iostream>
#include "command.h"

#include "commands/help.h"
#include "commands/list.h"
#include "commands/add.h"
#include "commands/post.h"
#include "commands/show.h"
#include "commands/assign.h"
#include "commands/join.h"
#include "commands/category.h"
#include "commands/summary.h"
#include "commands/stat.h"

namespace bugxee {

  void
  registerAllCommands()
  {
    command::getAddCommandFactory();
    command::getPostCommandFactory();
    command::getListCommandFactory();
    command::getShowCommandFactory();
    command::getAssignCommandFactory();
    command::getJoinCommandFactory();
    command::getCategoryCommandFactory();
    command::getSummaryCommandFactory();
    command::getStatCommandFactory();
    command::getHelpCommandFactory();
  }


  AbstractCommand::AbstractCommand(Repository& repository)
    : repository_(repository),
      factory_(NULL)
  {
  }

  AbstractCommand::~AbstractCommand()
  {
  }



  AbstractCommandFactory::AbstractCommandFactory(char const* name,
                                                 char const* description,
                                                 char const* usage)
    : name_(name),
      description_(description),
      usage_(usage)
  {
    factories()[name] = this;
  }

  AbstractCommandFactory::~AbstractCommandFactory()
  {
  }


  AbstractCommandFactory::FactoryPool&
  AbstractCommandFactory::factories()
  {
    static AbstractCommandFactory::FactoryPool inst;
    return inst;
  }


  void
  AbstractCommandFactory::build(AbstractCommand* cmd) const
  {
    cmd->factory_ = const_cast<AbstractCommandFactory*>(this);
  }



  AbstractCommandFactory const*
  AbstractCommandFactory::findByName(char const* name)
  {
    FactoryPool::iterator i = factories().find(name);
    if (i == factories().end())
      return NULL;
    return i->second;
  }

  /**
     Print out command specific usage.
   */
  void
  AbstractCommandFactory::printUsage() const
  {
    std::cerr << usage() << std::endl;
  }
}
