// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief 

   @author seagull
   @version "$Id: command.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__COMMAND_H__)
#define __BUGXEE__COMMAND_H__

#include <string>
#include <map>

#include "Repository.h"

namespace bugxee {

  class AbstractCommand;


  class AbstractCommandFactory
  {
  public:
    typedef std::map<std::string, AbstractCommandFactory const*> FactoryPool;
  protected:
    char const* name_;
    char const* description_;
    char const* usage_;

  public:
    AbstractCommandFactory(char const* name,
                           char const* description,
                           char const* usage);
    virtual ~AbstractCommandFactory();

    virtual AbstractCommand* create(Repository& repository) const = 0;
    virtual void build(AbstractCommand* cmd) const;
    
    char const* name() const { return name_; }
    char const* description() const { return description_; }
    char const* usage() const { return usage_; }

    static AbstractCommandFactory const* findByName(char const* name);
    static FactoryPool& factories();
    void printUsage() const;
  };



  class AbstractCommand
  {
    friend void AbstractCommandFactory::build(AbstractCommand* cmd) const;
  protected:
    Repository& repository_;
    AbstractCommandFactory* factory_;

  public:
    AbstractCommand(Repository& repository);
    virtual ~AbstractCommand();

    Repository& repository() const { return repository_; }

    virtual void parseOptions(int argc, char* argv[]) = 0;
    virtual void perform() = 0;

    inline AbstractCommandFactory* factory() const { return factory_; }
    inline void printUsage() const { factory_->printUsage(); }
  };



  template <typename T>
  class GenericCommandFactory
    : public AbstractCommandFactory
  {
  public:
    GenericCommandFactory(char const* name,
                          char const* description,
                          char const* usage)
      : AbstractCommandFactory(name, description, usage)
    {
    }

    virtual AbstractCommand* create(Repository& repository) const
    {
      T* p = new T(repository);
      build(p);
      return p;
    }
  };



  void registerAllCommands();
}


#endif
