// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief assign command

   @author seagull
   @version "$Id: assign.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__COMMAND__ASSIGN_H__)
#define __BUGXEE__COMMAND__ASSIGN_H__

#include <iostream>
#include <stdexcept>
#include <string>
#include <set>

#include "../Repository.h"
#include "../BugItem.h"
#include "../command.h"

namespace bugxee {
  namespace command {

    class AssignCmd
      : public AbstractCommand
    {
    protected:
      std::string maintener_;
      std::string status_;
      unsigned int priority_;
      std::string addedCategory_;
      std::string removedCategory_;

      std::set<int> targets_;  ///< Target BUG#s

    public:
      AssignCmd(Repository& repository);

      virtual void parseOptions(int argc, char* argv[]);
      virtual void perform();
    };

    AbstractCommandFactory const* getAssignCommandFactory();
  }
}


#endif
