// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief category command

   @author seagull
   @version "$Id: category.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "../common.h"

#include <iostream>
#include <iomanip>

#include <boost/bind.hpp>

#include "../Exception.h"
#include "../charsets.h"
#include "../log.h"
#include "../command.h"
#include "category.h"


namespace bugxee {
  namespace command {


    /**
       Get a factory for join command.
     */
    AbstractCommandFactory const* getCategoryCommandFactory()
    {
      static GenericCommandFactory<CategoryCmd>
        factory("category",
                _("Add category."),
                _("Usage: bugxee [global options...] category CATEGORIES...")
                );
      return &factory;
    }


    /**
       Parse command line arguments.
       @param argc ARGC
       @param argv ARGV
     */
    void
    CategoryCmd::parseOptions(int argc, char* argv[])
    {
      while (argc > 0)
        {
          categories_.insert(argv[0]);

          argc--;
          argv++;
        }
    }


    /**
       Perform join command.
    */
    void
    CategoryCmd::perform()
    {
      std::for_each(categories_.begin(), categories_.end(),
                    boost::bind(&Repository::addCategory,
                                boost::ref(repository()), _1) );
    }

  }
}
