// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief assign command

   @author seagull
   @version "$Id: help.cpp,v 1.2 2004/01/14 04:23:55 seagull Exp $"
 */
#include "common.h"

#include <iostream>
#include <iomanip>
#include "charsets.h"
#include "log.h"
#include "command.h"
#include "help.h"

void printUsage();

namespace bugxee {
  namespace command {


    AbstractCommandFactory const*
    getHelpCommandFactory()
    {
      static GenericCommandFactory<HelpCmd>
        factory("help",
                _("Show command help."),
                _("Usage: bugxee [global options...] help [COMMAND]\n")
                );
      return &factory;
    }


    /**
       Constractor
       @param repository Target repository.
    */
    HelpCmd::HelpCmd(Repository& repository)
      : AbstractCommand(repository)
    {
    }

    
    /**
       Parse comamnd specific options.
       @param argc ARGC
       @param argv ARGV
    */
    void HelpCmd::parseOptions(int argc, char* argv[])
    {
      targetCommand_.clear();
      if (argc >= 1)
        targetCommand_ = argv[0];
    }


    /**
       Perform command
     */
    void HelpCmd::perform()
    {
      if (targetCommand_.empty())
        ::printUsage();
      else
        {
          bugxee::AbstractCommandFactory const* factory = 
            bugxee::AbstractCommandFactory::findByName(targetCommand_.c_str());
          if (! factory)
            {
              ::printUsage();
              throw std::runtime_error(_("Unknown command for help."));
            }
          else
            factory->printUsage();
        }
    }
  }
}
