// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief join command

   @author seagull
   @version "$Id: join.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "../common.h"

#include <iostream>
#include <iomanip>
#include "../Exception.h"
#include "../charsets.h"
#include "../log.h"
#include "../command.h"
#include "join.h"


namespace bugxee {
  namespace command {


    /**
       Get a factory for join command.
     */
    AbstractCommandFactory const* getJoinCommandFactory()
    {
      static GenericCommandFactory<JoinCmd>
        factory("join",
                _("Join a maintener."),
                _("Usage: bugxee [global options...] join MAINENERS...")
                );
      return &factory;
    }


    /**
       Parse command line arguments
       @param argc ARGC
       @param argv ARGV
     */
    void
    JoinCmd::parseOptions(int argc, char* argv[])
    {
      while (argc > 0)
        {
          mainteners_.insert(argv[0]);

          argc--;
          argv++;
        }
    }


    /**
       Perform join command
    */
    void
    JoinCmd::perform()
    {
      for (std::set<std::string>::iterator i = mainteners_.begin();
           i != mainteners_.end(); i++)
        repository().joinMaintener(i->c_str());
    }

  }
}
