// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief list command

   @author seagull
   @version "$Id: list.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#if !defined(__BUGXEE__COMMAND__LIST_H__)
#define __BUGXEE__COMMAND__LIST_H__

#include <string>
#include <list>
#include <set>

#include "../Repository.h"
#include "../command.h"

namespace bugxee {
  namespace command {

    class ListCmd
      : public AbstractCommand
    {
    protected:
      std::list<std::string> statuses_; ///< Filter by status
      std::string maintener_;          ///< Filter by mentainner
      std::set<int> priorities_;      ///< Filter by priority
      std::set<std::string> categories_; ///< Filter by category
      unsigned int skip_;    ///< Output skip count. No skip if zero.
      unsigned int count_;   ///< Output limit count. Unlimited if zero.

    public:
      ListCmd(Repository& repository);

      virtual void parseOptions(int argc, char* argv[]);
      virtual void perform();
    };

    AbstractCommandFactory const* getListCommandFactory();
  }
}


#endif
