// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Module of 'post' command.
   @author seagull
   @version "$Id: post.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__COMMAND__POST_H__)
#define __BUGXEE__COMMAND__POST_H__

#include <set>
#include <memory>

#include "../Repository.h"
#include "../BugItem.h"
#include "../Message.h"
#include "../command.h"

namespace bugxee {
  namespace command {

    class PostCmd
      : public AbstractCommand
    {
    protected:
      std::auto_ptr<char> message_;
      std::set<int> bugnos_;

    public:
      PostCmd(Repository& repository);

      virtual void parseOptions(int argc, char* argv[]);
      virtual void perform();
    };

    AbstractCommandFactory const* getPostCommandFactory();
  }
}


#endif
