// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief show command

   @author seagull
   @version "$Id: show.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "../common.h"

#include <iostream>
#include <iomanip>
#include "../Exception.h"
#include "../charsets.h"
#include "../log.h"
#include "../command.h"
#include "../Outputter.h"
#include "../Preferences.h"
#include "show.h"


namespace bugxee {
  namespace command {


    AbstractCommandFactory const*
    getShowCommandFactory()
    {
      static GenericCommandFactory<ShowCmd>
        factory("show",
                _("Show bug details."),
                _("Usage: bugxee [global options...] show BUG#... \n")
                );
      return &factory;
    }

    /**
       Constractor
       @param repository Target repository.
    */
    ShowCmd::ShowCmd(Repository& repository)
      : AbstractCommand(repository)
    {
    }

    
    /**
       Parse comamnd specific options.
       @param argc ARGC
       @param argv ARGV
    */
    void ShowCmd::parseOptions(int argc, char* argv[])
    {
      while (argc > 0)
        {
          if (argv[0][1] == '-')
            {
              switch (argv[0][2])
                {
                default:
                  throw UnknownOptionError(argv[0]);
                  
                }
            }
          else
            {
              targets_.insert(atoi(argv[0]));
            }
          argc--;
          argv++;
        }
    }


    /**
       Perform command
     */
    void
    ShowCmd::perform()
    {
      Preferences& pref = Preferences::instance();
      std::auto_ptr<AbstractOutputter> outputter =
        AbstractOutputterFactory::create(pref.outputFormat(), std::cout);

      outputter->setTotalCount(targets_.size());
      outputter->start();

      // Print bug details.
      for (std::set<int>::iterator i = targets_.begin();
           i != targets_.end(); i++)
        {
          BugItem* bug = repository().findByBugno(*i);
          if (! bug)
            std::cout << _("** Can't be load BUG#")  << *i << std::endl;
          else
            outputter->writeDetail(bug);
        }
      outputter->finish();
    }
  }
}
