// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Module of "summary" command
   @author seagull 
   @version "$Id: summary.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */
#include "../common.h"

#include <limits>

#include <boost/bind.hpp>
#include <boost/mem_fn.hpp>

#include "../../lib/getdate.h"
#include "../Exception.h"
#include "../log.h"
#include "../editor.h"
#include "../command.h"
#include "summary.h"

namespace bugxee {
  namespace command {

    AbstractCommandFactory const* getSummaryCommandFactory()
    {
      static GenericCommandFactory<SummaryCmd>
        factory("summary",
                _("Generate summary of BUG activities."),
                _("Usage: bugxee [global options...] summary -D date [-D date]\n"
                  "")
                );
      return &factory;
    }


    /**
       Constractr
       @param repository Target repository
     */
    SummaryCmd::SummaryCmd(Repository& repository)
      : AbstractCommand(repository)
    {
        timespan_.first = 0;
        timespan_.second = std::numeric_limits<time_t>::max();
    }


    /**
       Parse command specific options.
     */
    void
    SummaryCmd::parseOptions(int argc, char* argv[])
    {
      time_t tmptime;
      bool first_specified = false;

      while (argc > 0)
        {
          if (argv[0][0] == '-')
            {
              switch (argv[0][1])
                {
                case 'D':
                  if (argc < 1)
                    throw InvalidOptionValue(_("option requires an argument -- D"));
                  tmptime = date::get_date(argv[1]);
                  if (tmptime < 0)
                    throw InvalidOptionValue(_("Invaid date format?"));
                  if (! first_specified)
                    {
                      timespan_.first = tmptime;
                      first_specified = true;
                    }
                  else
                    timespan_.second = tmptime;
                  argv++;
                  argc--;
                  break;

                default:
                  throw UnknownOptionError(argv[0]);
                }
            }
          else
            throw UnknownOptionError(argv[0]);

          argc--;
          argv++;
        }
    }


    /**
       Parform add command.
     */
    void
    SummaryCmd::perform()
    {
    }
  }
}
