// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief Module of "summry" command.
   @author seagull
   @version "$Id: summary.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__COMMAND__SUMMARY_H__)
#define __BUGXEE__COMMAND__SUMMARY_H__

#include <ctime>
#include <set>
#include <utility>

#include "../Repository.h"
#include "../BugItem.h"
#include "../Message.h"
#include "../command.h"

namespace bugxee {
  namespace command {

    class SummaryCmd
      : public AbstractCommand
    {
    protected:
      std::pair<time_t, time_t> timespan_;

    public:
      SummaryCmd(Repository& repository);

      virtual void parseOptions(int argc, char* argv[]);
      virtual void perform();
    };

    AbstractCommandFactory const* getSummaryCommandFactory();
  }
}


#endif
