// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief External editor(e.g vi) support module

   @author seagull
   @version "$Id: editor.cpp,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
*/
#include "common.h"

#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <sys/types.h>
#include <unistd.h>

#include "Exception.h"
#include "editor.h"

namespace bugxee {

  ExternalEditor::ExternalEditor(char const* tmpl)
  {
    char const* cmdline = std::getenv("EDITOR");
    if (! cmdline || ! *cmdline)
      throw std::invalid_argument(_("No specified external editor, please set to EDITOR"));
    commandLine_ = cmdline;

    if (tmpl)
      commandLine_.append(tmpl);
  }

  std::auto_ptr<char>
  ExternalEditor::launch() const throw (std::runtime_error)
  {
    char const* tmpdir = std::getenv("TMP");
    if (!tmpdir) tmpdir = std::getenv("TMPDIR");
    if (!tmpdir) tmpdir = std::getenv("TEMP");
    if (!tmpdir) tmpdir = "/tmp";

    std::auto_ptr<char> tmppath(new char[std::strlen(tmpdir) + 15]);

    std::sprintf(tmppath.get(), "%s/bugxee-XXXXXX", tmpdir);
    int fd = mkstemp(tmppath.get());

    try
      {
        std::system((commandLine_ + " " + tmppath.get()).c_str());
        off_t size = ::lseek(fd, 0, SEEK_END);
        ::lseek(fd, 0, SEEK_SET);

        std::auto_ptr<char> buf(new char[size + 1]);
        if (::read(fd, buf.get(), size) != size)
          throw OSError(_("reading temp file"));
        buf.get()[size] = '\0';
        ::close(fd);
        return buf;
      }
    catch (std::exception& e)
      {
        ::close(fd);
        throw;
      }
  }


}
