// -*- mode:c++; indent-tabs-mode:nil; tab-width:2;buffer-file-coding-system:euc-jp-unix; -*-
/**
   @file
   @brief External editor(e.g vi) support module.

   @author seagull
   @version "$Id: editor.h,v 1.1.1.1 2004/01/12 12:19:12 seagull Exp $"
 */

#if !defined(__BUGXEE__EDITOR_H__)
#define __BUGXEE__EDITOR_H__

#include <stdexcept>
#include <string>
#include <memory>

namespace bugxee
{
  class ExternalEditor
  {
  protected:
    std::string tmpFileName_;
    std::string commandLine_;

  public:
    //@{ @name constractors.
    ExternalEditor(char const* tmpl = NULL);

    //@{ Access to property
    inline std::string const& tmpFileName() const { return tmpFileName_; }
    inline std::string const& commandLine() const { return commandLine_; }
    //@}

    std::auto_ptr<char> launch() const throw (std::runtime_error);
  };

}

#endif
