<?php
include '../env.php';
require_once(LIB.'common.inc.php');
require_once(LIB.'Post.class.php');
$post = new Post();

if (empty($_POST['t']) || ! $post->isValidFavoriteType($_POST['t'])) {
	_a_log_fail('f-error', 'create', 'invalid item type');
	echo json_encode(FALSE);
	die;
}

if (! can_action('view') || !is_login()) {
	_a_log_fail('f-'.$_POST['t'], 'create', 'invalid auth');
	echo json_encode(FALSE);
	die;
}

$log_ret = _a_log2('f-'.$_POST['t'], 'create', array(
	'detail' => serialize($_POST),
	'target_key' => @$_POST['key']
));

if ($log_ret) {
	$is_favorited = $post->isFavorited($_POST['t'], @$_POST['key']);
	if ($is_favorited) {
		$log_ret->data['detail'] = 'already favorited: '.$log_ret->data['detail'];
		$ret = TRUE;
	} else {
		$ret = $post->addFavoriteItem($_POST['t'], @$_POST['key']);
	}
	_a_log_write($log_ret, array('success' => $ret === FALSE ? '0' : '1'));

	if ($ret === FALSE) {
		echo json_encode($ret);
	} else {
		echo json_encode(array(
			'favorited' => TRUE,
			'count' => $post->countFavorite($_POST['t'], @$_POST['key'])
		));
	}
} else {
	echo json_encode(FALSE);
}
?>