<?php
include '../env.php';
require_once(LIB.'common.inc.php');
if (can_action('view')) {
	require_once(LIB.'Post.class.php');
	$post = new Post();
	$contents = $post->get($_GET);
	if (! empty($contents)) {
		header('Content-type: text/html; charset=utf8');
		foreach ($contents as $content) {
?>
<div class="bullet-content" id="content<?php echo $content['id'];?>">
	<div class="bullet-header">
		<?php
			echo '<a href="'.BASE_URL;
			if ($content['user_id']) {
				echo 'user/'.rawurlencode($content['login_id']).'" class="bullet-name bullet-user'.$content['t'].'">'.h($content['n']).'</a>';
			} else {
				echo 'name/'.rawurlencode($content['n']).'" class="bullet-name">'.h($content['n']).'</a>';
				if ($content['trip']) {
					echo '<a href="'. BASE_URL.'trip/'.rawurlencode($content['trip']).'" class="bullet-name">@'.h($content['trip']).'</a>';
				}
			}
			?><span class="bullet-user">-</span><span class="bullet-time"><?php echo $content['created'];?></span>
	</div>
	<div class="bullet-body">
<?php
		$lines = explode("\n", h($content['content']));
		echo '<span>'.implode ('</span><br/><span>', $lines).'</span>';
?>
	</div>
	<div class="bullet-tag">
<?php
	if ($content['t_theme']) {
		echo '<a href="'.BASE_URL.'theme/'.rawurlencode($content['t_theme']).'" style="font-weight:bold">'.h($content['t_theme']).'</a>';
	}
	$tags = json_decode($content['jt']);
	if ($tags) {
		foreach ($tags as $tag) {
			echo '<a href="'.BASE_URL.'theme/'.rawurlencode($tag).'">'.h($tag).'</a>';
		}
	}
?>
	</div>
	<div class="bullet-action"><a href="<?php echo BASE_URL.'read/'.$content['id'];?>">詳細</a></div>
</div>
<?php
		}
	}
}
?>