Favo = {}
Favo.delFavorite = function(favo, container) {
	if (! confirm(favo.name+"を本当に削除してよろしいですか？"))
		return;
	var loading = $("<div/>");
	container.append(loading);
	container.find("a").button("disable");
	loading.spin();
	$.post2(
		T.api+"del_favorite.php",
		{id: favo.id},
		function(ret) {
			if (! ret) {
				alert("削除に失敗しました。");
				container.find("a").button("enable");
				loading.remove();
				return;
			}
			Favo.updateUnknownFavo();
			container.remove();
		},
		function() {
			alert("削除に失敗しました。");
			container.find("a").button("enable");
			loading.remove();
		},
		"json"
	);
}
Favo.switchZ = function(e) {
	//$(".favorite_container").css("z-index", "0");
	$(".favorite_container").each(function() {
		var z = $(this).css("z-index");
		if (z > 0) {
			$(this).css("z-index", z-1);
		}
	});
	if ($(e.target).hasClass("favorite_container")) {
		$(e.target).css("z-index", 100);
	} else {
		$(e.target).parents(".favorite_container").css("z-index", 100);
	}
}
Favo.changeName = function(id, old, name) {
	if (! id)
		return;
	if (old == name)
		return;
	$.post2(
		T.api+"update_favorite.php",
		{id: id, name: name},
		function(ret) {
			if (! ret) {
				alert("お気に入りデータの更新に失敗しました。\\nお気に入り名が一意になっているかを確認して再度更新してください。");
				$("#update-name-dialog").dialog("close");
				return;
			}
			$("#"+id).find("h4 a").text(name);
			$("#update-name-dialog").dialog("close");
		},
		function() {
			alert("お気に入りデータの更新に失敗しました。\\nお気に入り名が一意になっているかを確認して再度更新してください。");
			$("#update-name-dialog").dialog("close");
		},
		"json"
	);
	
}
Favo.updateUnknownFavo = function(callback) {
	$.get2(
		T.api+"get_favorite_items.php?"+T.now,
		function(ret) {
			if (! ret) {
				alert("未分類アイテムの取得に失敗しました。");
			}
			var unknown_favo = {
				name: "未分類"
			}
			unknown_favo.items = ret;
			Favo.generateFavorite(unknown_favo, "unknown", true);
			if (callback) {
				callback();
			}
		},
		function() {
			alert("未分類アイテムの取得に失敗しました。");
		},
		"json"
	);
}
Favo.generateFavorite = function(favo, id, no_del) {
	var container;
	var already = false;
	if (id && $("#"+id).length) {
		container = $("#"+id);
		already = true;
	} else {
		container = $("<div/>").addClass("favorite_container").addClass("ui-widget-content").addClass("ui-corner-all");
		container.attr("id", id ? id : favo["id"]);
	}

	var ul = $("<ul class='favo-item'/>");
	if (! favo.items || favo.items.length == 0) {
		ul.append($("<li/>").addClass("nothing-item").text("まだアイテムが登録されていません。"));
	} else {
		for (var i=0; i<favo.items.length; i++) {
			var text = favo.items[i].target_type+":"+favo.items[i].target_key;
			if (favo.items[i].target_type == "post") {
				text = favo.items[i].info;
			} else if (favo.items[i].target_type == "url") {
				text = "URL: " + favo.items[i].info;
			} else if (favo.items[i].target_type == 'theme') {
				text = "テーマ: " + favo.items[i].target_key;
			} else if (favo.items[i].target_type == "user") {
				text = "ユーザ: " + favo.items[i].info;
			} else if (favo.items[i].target_type == "name") {
				text = "ID: " + favo.items[i].target_key;
			} else if (favo.items[i].target_type == "trip") {
				text = "トリップ: " + favo.items[i].target_key;
			} else if (favo.items[i].target_type == "my") {
				text = "[自分の書き込み]";
			}
			ul.append(
				$("<li/>").attr("i", favo.items[i].id)
					.text(
						text+ " - "+T.countdown_by2(favo.items[i].created)
					)
					.draggable({
						revert: "invalid",
						helper: "clone",
						//appendTo: $("#content-container .favo"),
						appendTo: $("#dummy-container"),
						cursor: "move",
						start: Favo.switchZ.apply(this, arguments)
					})
			);
		}
	}
	if (already) {
		var items = container.find(".favo-items");
		items.find("ul").remove();
		items.append(ul);
	} else {
		$("<h4/>").addClass("ui-widget-header").addClass("ui-corner-top").append(
			(favo.id === undefined) ? $("<span/>").text(favo.name) : $("<a/>").text(favo.name).attr("href", T.base+"favorite/"+favo.id)
		).appendTo(container);
		var items = $("<div/>").addClass("favo-items");
		items.append(ul);
		items.appendTo(container);

		if (! no_del) {
			var del_button = $("<a/>").text("削除").button({icons:{primary:"ui-icon-trash"}});
			del_button.click(function() {
				Favo.delFavorite(favo, container);
			});
			var update_button = $("<a/>").text("修正").button({icons:{primary:"ui-icon-pencil"}});
			update_button.click(function() {
				$("#name").val(favo.name);
				$( "#update-name-dialog" ).attr("i", favo.id).attr("old", favo.name).dialog( "open" );
			});
			$("<div/>").addClass("control-buttons").append(del_button).append(" ").append(update_button).appendTo(items);
		}
		container.draggable({
			handle: ".ui-widget-header",
			start: Favo.switchZ
		});
		container.droppable({
			accept: ".favo-item li",
			hoverClass: "ui-state-active",
			drop: function(event, ui) {
				var del_target = $(ui.draggable).parents(".favorite_container");
				if (container.attr("i") == del_target.attr("i")) {
					return;
				}
				$(ui.draggable).appendTo(
					container.find("ul")
				);
				container.find(".nothing-item").remove();
				if (del_target.attr("i")) {
					$.post2(
						T.api+"update_favorite.php",
						{id: del_target.attr("i"), del_id: $(ui.draggable).attr("i")},
						function(ret) {
							if (! ret) {
								return;
							}
						},
						function() {
							alert("お気に入りデータの更新に失敗しました。");
							location.reload();
						},
						"json"
					);
				}
				if (container.attr("i")) {
					$.post2(
						T.api+"update_favorite.php",
						{id: container.attr("i"), add_id: $(ui.helper).attr("i")},
						function(ret) {
							if (! ret) {
								return;
							}
						},
						function() {
							alert("お気に入りデータの更新に失敗しました。");
							location.reload();
						},
						"json"
					);
				}
			}
		});
		container.attr("i", favo.id);
		container.appendTo($(".favo"));
	}
}

Favo.initComponents = function() {
	$(".time").each(function() {
		var t = $(this).text();
		if (t)
			$(this).text(T.countdown_by2($(this).text()));
	});
	if ($(".control-panel").length) {
		$(".control-panel").draggable({handle: ".ui-widget-header"});
		$("#new-favorite").button({icons:{primary:"ui-icon-document"}}).click(function() {
			$(".control-panel .control-buttons a").button("disable");
			$("<div id='newl'/>").insertAfter(".control-panel .control-buttons").spin();
			$.post2(
				T.api+"new_favorite.php",
				function(ret) {
					if (! ret) {
						alert("お気に入りを作成出来ませんでした。")
					} else {
						Favo.generateFavorite(ret);
					}
					$(".control-panel .control-buttons a").button("enable");
					$("#newl").remove();
				},
				function() {
					alert("お気に入りを作成出来ませんでした。")
					$(".control-panel .control-buttons a").button("enable");
					$("#newl").remove();
				},
				"json"
			);
		});

		$("<div id='l'/>").appendTo(".favo").spin();
		$(".control-buttons a").button("disable");

		Favo.updateUnknownFavo(function() {
			$.get2(
				T.api+"get_favorite.php",
				function(ret) {
					if (! ret) {
						alert("お気に入りの取得に失敗しました。");
						return;
					}
					for (var i=0; i<ret.length; i++) {
						Favo.generateFavorite(ret[i]);
					}
					$(".control-buttons a").button("enable");
					$("#l").remove();
				},
				function() {
					alert("お気に入りの取得に失敗しました。");
				},
				"json"
			);
		});

		$(".control-panel")
			.css("left", ($(".favo").innerWidth() / 2 - $(".control-panel").outerWidth() / 2)+"px")
			.css("top", ($(".favo").innerHeight() / 2 - $(".control-panel").outerHeight() / 2) + "px");

		$("#control-panel").droppable({
			accept: ".favo-item li",
			hoverClass: "ui-state-active",
			greedy: true,
			drop: function(event, ui) {
				if (! confirm("このアイテムを削除します。よろしいですか？"))
					return;
				$.post2(
					T.api+"del_favorite_item_by_id.php",
					{id: $(ui.draggable).attr("i")},
					function(ret) {
						location.reload();
					},
					function() {
						location.reload();
					},
					"json"
				);
			}
		});

		Favo.manageMode = true;
	}

	$(window).resize(function() {
		$(".favo").css("height", $(window).innerHeight()-$("#main-container").offset().top-16+"px");
		var l = $("#l");
		if (l.length) {
			l.css("position", "relative")
			 .css("left", $(".favo").innerWidth() / 2 - l.innerWidth() / 2 + "px") 					
			 .css("top", $(".favo").innerHeight() / 2 - l.innerHeight() / 2 + "px")
		}
	});

	$("#update-name-dialog").dialog({
		autoOpen: false,
		modal: true,
		title: "名前の変更",
		buttons: {
			"変更": function() {
				Favo.changeName(
					$(this).attr("i"),
					$(this).attr("old"),
					$("#name").val()
				);
			},
			"キャンセル": function() {
				$(this).dialog("close");
			}
		} 
	});

	$(window).resize();
}