<?php
class Formatter {
	function getUrl($url) {
		if (substr($url, 0, 4) != 'http') {
			$ssl = isset($_SERVER['HTTPS']);
			$default_port = $ssl ? '443' : '80';
			return ($ssl ? 'https' : 'http') . '://'. $_SERVER['SERVER_NAME']. ($_SERVER['SERVER_PORT'] == $default_port ? '' : ':'.$_SERVER['SERVER_PORT']).$url;
		}
		return $url;
	}
	function rss2($posts) {
		header('Content-type: application/rss+xml; charset=utf8');

		$xml = simplexml_load_string('<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
	xmlns:admin="http://webns.net/mvcb/"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
</rss>');
		$channel = $xml->addChild('channel');
		$channel->addChild('title', TITLE);
		$channel->addChild('link', $this->getUrl(BASE_URL));
		$channel->addChild('description', DESCRIPTION);
		$channel->addChild('language', 'ja');
		foreach ($posts as $p) {
			$item = $channel->addChild('item');
			$item->addChild('description', str_replace('&', '&amp;', $p['content']));
			$item->addChild('pubDate', date('r', strtotime($p['created'])));
			$item->addChild('title', str_replace('&', '&amp;', $p['n'].'の投稿'));
			$item->addChild('link', $this->getUrl(BASE_URL.'read/'.$p['id']));
		}
		return $xml->asXML();
	}
}
?>