<?php
class Setting {
	static $settings;

	static function Load() {
		$ret = @file_get_contents(DATA.'app.conf');
		if (empty($ret)) {
			self::$settings = array();
			return FALSE;
		}

		self::$settings = unserialize($ret);
		return TRUE;
	}

	static function Save() {
		return file_put_contents(DATA.'app.conf', serialize(self::$settings));
	}

	static function Get($key, $default='') {
		if (! isset(self::$settings[$key]))
			return $default;
		return self::$settings[$key];
	}

	static function Set($key, $value) {
		self::$settings[$key] = $value;
		return self::Save();
	}

	static function Del($key) {
		if (! isset(self::$settings[$key]))
			return TRUE;

		unset(self::$settings[$key]);
		return self::Save();
	}
}