<?php
require_once(LIB.'CSSParser.php');
class Skin {
	var $colors;
	var $org_colors;
	var $target_dir;

	function __construct($target_dir=NULL) {
		if (empty($target_dir)) {
			$this->target_dir = dirname(dirname(__FILE__)).'/css/';
		} else {
			$this->target_dir = $target_dir;
		}
		$this->org_colors = array(
			'basic' => '#285c00',
			'border' => '#72b42d',
			'hr-color' => '#45930B',
			'hover-color' => '#3a8104',
			'admin' => '#ff0',
			'operator' => '#f92'
		);
	}

	function load($skin) {
		$cssParser = new CSSParser(file_get_contents($this->target_dir.$skin.'/jquery-ui-1.9.2.custom.css'));
		$widget_content = $cssParser->getSelector('.ui-widget-content');
		$widget_header = $cssParser->getSelector('.ui-widget-header');
		$state_default = $cssParser->getSelector('.ui-state-default');
		$this->colors = array(
			'basic' => $this->getBackgroundColor($widget_content),
			'border' => $this->getBordercolor($widget_content),
			'hr-color' => $this->getBordercolor($state_default),
			'hover-color' => $this->getBorderColor($widget_header),
			'admin' => '#ff0',
			'admin' => '#f92'
		);
	}

	function getSkinList() {
		$dir_list_tmp = glob($this->target_dir.'*');
		$dir_list = array();
		foreach ($dir_list_tmp as $v) {
			if ($v != '.' && $v != '..' && is_dir($v)) {
				$dir_list[] = basename($v);
			}
		}
		return $dir_list;
	}

	function getCssList() {
		$css_list_tmp = glob($this->target_dir.'*.css');
		$css_list = array();
		foreach ($css_list_tmp as $v) {
				$css_list[] = basename($v);
		}
		return $css_list;
	}

	function backup($css) {
		if (! file_exists($this->target_dir.$css.'_'))
			return copy($this->target_dir.$css, $this->target_dir.$css.'_');
		return TRUE;
	}

	function generate($skin=NULL) {
		if ($skin)
			$this->load($skin);
		$css_list = $this->getCssList();
		$ret = TRUE;
		foreach ($css_list as $css) {
			$tmp_ret = $this->generateCss($css);
			if ($tmp_ret === FALSE)
				$ret = FALSE;
		}
		return $ret;
	}

	function generateCss($css) {
		if (empty($this->colors))
			return FALSE;
		if (! $this->backup($css))
			return FALSE;

		$org = file_get_contents($this->target_dir.$css.'_');
		$out = $org;
		foreach ($this->org_colors as $k => $org_color) {
			$out = str_replace($org_color, $this->colors[$k], $out);
		}
		return file_put_contents($this->target_dir.$css, $out);
	}

	function restoreAll() {
		$css_list = $this->getCssList();
		foreach ($css_list as $css) {
			$this->restore($css);
		}
		return TRUE;
	}

	function restore($css) {
		if (file_exists($this->target_dir.'/'.$css.'_')) {
			@unlink($this->target_dir.'/'.$css);
			@rename($this->target_dir.'/'.$css.'_', $this->target_dir.'/'.$css);
		}
	}

	function getBackgroundColor($obj) {
		foreach ($obj as $p => $v) {
			if ($p == 'background-color') {
				return $v[0];
			} else if ($p == 'background') {
				$t = explode(' ', $v[0]);
				return $t[0];
			}
		}
		return '';
	}
	function getBorderColor($obj) {
		foreach ($obj as $p => $v) {
			if ($p == 'border-color') {
				return $v[0];
			} else if ($p == 'border') {
				$t = explode(' ', $v[0]);
				return $t[count($t) - 1];
			}
		}
		return '';
	}

}