<?php
//-------- server side environment --------
// ベースのURLです。.htaccess側の設定も忘れないで下さい
define('BASE_URL', '/');
// APIのURLです
define('API_URL', BASE_URL.'api/');
// CSSのURLです
define('CSS_URL', BASE_URL.'css/');
// JavaScriptのURLです
define('JS_URL', BASE_URL.'js/');
// アップロード画像のURLです
define('IMG_URL', BASE_URL.'img/');
// タイムゾーン。東京の場合Asia/Tokyoにします。DBに合わせてください
define('TIMEZONE', 'Asia/Tokyo');

// 画像アップ時に作成するサブディレクトリの階層数を指定します。例: 3の場合、abcdefg.jpgはa/b/c/defg.jpgになります
define('IMG_DIR_COUNT', 4);
// 縦横の最大サイズを指定します。このサイズより大きい画像は自動的にリサイズされます。なお、リサイズの有無に関わらず、アップされた画像は一度PHP側でリサンプリングされます
define('IMG_MAX_SIZE', 800);
// JPEGのリサンプル後の画質を指定します
define('IMG_JPEG_QUALITY', 90);
// 画像アップロード機能を有効にします
define('ENABLE_IMG_UPLOAD', TRUE);

//-------- pages --------
// ヘッダーにログインメニューを出します
define('LOGIN_MENU', TRUE);
// サイトのタイトルです
define('TITLE', '雪助');
// サイトの説明です。meta descriptionとして設定されます
define('DESCRIPTION', 'テーマ指向のミニブログ（短文投稿サービス）のデモサイトです');
// サイトのキーワードです。meta keywordとして設定されます
define('KEYWORD', 'ミニブログ,短文投稿,テーマ指向,雪助');

//Google AdSenseボックスを利用する場合の広告コードです。必要な場合定義してください
/*define('GOOGLE_ADSENSE', 'google_ad_client = "ca-pub-5067037356613716";
google_ad_slot = "9643944686";
google_ad_width = 250;
google_ad_height = 250;');*/

//-------- posts --------
// 投稿時にメインテーマを除いてこれ以上の個数のテーマは取り除かれます。0の場合は無制限です。
// 負の値にするとテーマ無し雪助が構築出来ます。
define('POST_MATCH_LIMIT', 0);
// 投稿時のマッチ方式を最長一致にするかどうかです。0の場合、全マッチになります。最長一致の方が、やや速度は遅いです。なお、この値が1の場合「こん」と「んにちは」が登録されており、こんにちはを検索すると「こん」がヒットし、2の場合「んにちは」がヒットします。通常は0か2がいいでしょう。それ以外の値だと一切ヒットしなくなります。
define('POST_MATCH_LONGEST', 2);
// 投稿時にメインテーマを除いてこれ以上の個数のURLの場合、エラーになります。0の場合は無制限です。
// 負の値にするとURLを投稿するとエラーになる雪助が構築出来ますが、あまり意味はありません。
define('POST_MATCH_URL_LIMIT', 0);
// 1にするとURLを解析し、キーワードを抽出します
define('POST_URL_KEYWORD', 0);
// 1にするとテーマタグを解析し、キーワードを抽出します
define('POST_THEMETAG_KEYWORD', 0);
// 1にするとメンションを解析し、キーワードを抽出します
define('POST_MENTION_KEYWORD', 0);

//-------- security --------
// ID生成に利用されるソルトです。必ず書き換えてください
define('BULLET_SECRET_KEY', '');
// ユーザパスワード暗号化に利用されるソルトです。必ず書き換えてください
define('BULLET_USER_SECRET_KEY', '');
// トリップ生成に利用されるソルトです。必ず書き換えてください
define('BULLET_TRIP_SECRET_KEY', '');

//-------- database --------
// DB種別です。現状はmysqlのみサポートされています
define('DB_ENGINE', 'mysql');
// DBサーバです
define('DB_HOST', 'localhost');
// DBの名前です
define('DB_NAME', '');
// DBの認証に用いるユーザです
define('DB_USER', '');
// DBのパスワードです
define('DB_PASS', '');
// DBの文字エンコードです。utf8を強く推奨します
define('DB_CHARSET', 'utf8');
// 各種テーブルにプリフィックスをつけます
define('TABLE_PREFIX', '');

//-------- expert option --------
// action logをとります。量が多いため、ハードディスクへの負担と処理速度の若干の低下を招きますが、運用上ほぼ必須のログであるためTRUEを推奨します
define('ENABLE_ACTION_LOG', TRUE);
// action logを基にしたファイアウォールを有効にします
define('ENABLE_BLOCK_TABLE', TRUE);
// theme_postsテーブルを複数（128）テーブルに分けます
define('MULTI_THEME_TABLE', FALSE);
// keyword_postsテーブルを複数（128）テーブルに分けます
define('MULTI_KEYWORD_TABLE', FALSE);
// url_postsテーブルを複数（128）テーブルに分けます
define('MULTI_URL_TABLE', FALSE);
//clear, refreshのページを有効にします。このオプションは、特にマルチテーブル環境プロジェクトの初期化に多少役に立ちます
//define('ACCEPT_DANGER_URL', TRUE);
?>