<?php
if (! can_action('admin'))
	redirect();

require_once(LIB.'Action.class.php');
$actionObj = new Action();
$id = @$params[0];
if (empty($id))
	redirect('actionlog');

$l = $actionObj->read($id);
$back_url = @$_GET['back_url'];

$title = 'ログ詳細: '.$l['log_id'];
$css_links = array('admin.css');
$script = <<<EOD
	$(function() {
		$("#log-table input[type='text']").tooltip()
	});
EOD;
include LAYOUTS.'header.inc.php';

$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<div>
				<a href="<?php echo $back_url; ?>">戻る</a>
			</div>
		</div>
		<div class="controller-box">
			<h2>基本情報</h2>
			<table id="user-table"><tbody>
				<tr>
					<th id="order-created">日時</th>
					<th id="order-ip">IP</th>
					<th id="order-id">ID</th>
					<th id="order-user">ユーザ</th>
					<th id="order-target">対象</th>
					<th id="order-action">行動</th>
					<th id="order-target_id">対象ID</th>
					<th id="order-success">成功</th>
				</tr>
<?php
		echo '<tr>';
		echo '<td>'.h($l['created']).'</td>';
		echo '<td>'.h($l['ip']).'</td>';
		echo '<td><a href="'.BASE_URL.'name/'.rawurlencode($l['id']).'">'.h($l['id']).'</a></td>';
		echo '<td><a href="'.BASE_URL.'user/'.rawurlencode($l['login_id']).'" title="'.h($l['display_name']).'">'.$l['login_id'].'</a></td>';
		echo '<td>'.h($l['target']).'</td>';
		echo '<td>'.h($l['action']).'</td>';

		echo '<td>';
		if ($l['target_id']) {
			if ($l['target'] == 'post') {
				echo '<a href="'.BASE_URL.'read/'.$l['target_id'].'">'.h($l['target_id']).'</a>';
			} else {
				echo h($l['target_id']);
			}
		} else {
			echo '-';
		}
		echo '</td>';

		echo '<td>'.($l['success'] ? '◆' : '').'</td>';

		echo '</tr>';
?>
			</tbody></table>
		</div>

		<div class="controller-box">
			<h2>対象詳細</h2>
			<div>
<?php
		if ($l['target_key']) {
			if ($l['target'] == 'image') {
				echo '<a href="'.IMG_URL.$l['target_key'].'">'.h(mb_truncate($l['target_key'], 100)).'</a>';
			} else if ($l['target'] == 'url') {
				echo '<a href="'.$l['target_key'].'">'.h(mb_truncate($l['target_key'], 100)).'</a>';
			} else {
				echo h(mb_truncate($l['target_key'], 100));
			}
		} else {
			echo '-';
		}
?>
			</div>
		</div>

		<div class="controller-box">
			<h2>詳細</h2>
			<div>
<?php
		if ($l['detail']) {
			$obj = @unserialize($l['detail']);
			if ($obj) {
				if ($l['target'] == 'layout') {
					if (@$obj['src'] && @$obj['dist']) {
						echo h($obj['src']).' から '.implode(',',$obj['dist']).' へコピー';
					} else {
						echo h($obj['page_name']);
						if ($obj['has']) {
							echo ' に '.h($obj['box_name']).' を追加';
						} else {
							echo ' から '.h($obj['box_name']).' を削除';
						}
					}
					echo '<br/>';
				} else if ($l['target'] == 'user') {
					if ($l['action'] == 'modify' && $l['success']) {
						if ($l['target_id'] != $l['user_id']) {
							$target_user = $actionObj->db->selectRow('users', NULL, array('id' => $l['target_id']));
							echo h($target_user['login_id']).' ('.$target_user['display_name'].'), id: '.$target_user['id'].' の 情報を変更<br/>';
						}
						foreach ($obj as $prop => $value) {
							echo h($prop).' を '.$value.' に変更';
							echo '<br/>';
						}
						echo '<br/>';
					} else if ($l['action'] == 'regist' && $l['success']) {
						foreach ($obj as $prop => $value) {
							echo h($prop).': '.$value;
							echo '<br/>';
						}
					}
				} else if ($l['target'] == 'box') {
					foreach ($obj as $k => $v) {
						if ($k == 'script')
							continue;
						echo $k.': '.$v.'<br/>';
					}
					echo '<pre>';
					echo h($obj['script']);
					echo '</pre>';
					echo '<br/>';
				}
			}
			echo h($l['detail']);
		} else {
			echo '-';
		}
?>
			</div>
		</div>

		<div class="controller-box">
			<h2>解析</h2>
			<div>
<?php
			if ($l['target'] == 'user') {
				if ($l['action'] == 'regist' && $l['success']) {
					echo 'id: '.$l['target_id'].'<br />';
				} else if ($l['action'] == 'modify' && $l['success']) {
					$old_logs = $actionObj->db->select(
						'action_logs',
						NULL,
						'log_id<? and target=? and target_id=? and action=? and success=1',
						array($l['log_id'], 'user', $l['target_id'], 'modify'),
						array('order' => 'log_id desc')
					);
					$regist_log = $actionObj->db->pureSelectRow(
						'action_logs',
						NULL,
						'log_id<? and target=? and target_id=? and action=? and success=1',
						array($l['log_id'], 'user', $l['target_id'], 'regist'),
						array('order' => 'log_id desc')
					);
					if ($regist_log)
						$regist_log_obj = unserialize($regist_log['detail']);
					$old_values = array();
					foreach ($obj as $prop => $value) {
						if ($prop == 'password') {
							$old_values[$prop] = '推測不可';
							continue;
						}
						$detected = FALSE;
						foreach ($old_logs as $old_log) {
							$d = @unserialize($old_log['detail']);
							if (empty($d))
								continue;
							if (array_key_exists($prop, $d)) {
								$detected = TRUE;
								$old_values[$prop] = array('id' => $old_log['log_id'], 'value' => $d[$prop]);
								break;
							}
						}
						if (! $detected) {
							if (! $regist_log) {
								$old_values[$prop] = '推測不可';
								continue;
							}
							if (array_key_exists($prop, $regist_log_obj)) {
								$old_values[$prop] = array(
									'id' => $regist_log['log_id'],
									'value' => $regist_log_obj[$prop]
								);
							} else {
								$old_values[$prop] = '推測不可';
							}
						}
					}

					foreach ($old_values as $prop => $old_value) {
						if (is_string($old_value)) {
							echo h($prop).' の 以前の値は '.$old_value;
						} else {
							echo h($prop).' の 以前の値は '.$old_value['value'].' (log: <a href="'.BASE_URL.'actiondetail/'.$old_value['id'].'/?back_url='.rawurlencode($back_url).'">'.$old_value['id'].'</a>)';
						}
						echo '<br/>';
					}
				}
			} else if ($l['target'] == 'box') {
				if ($l['action'] == 'modify' && $l['success']) {
					$old_logs = $actionObj->db->select(
						'action_logs',
						NULL,
						'log_id<? and target=? and target_key=? and action=? and success=1',
						array($l['log_id'], 'box', $l['target_key'], 'modify'),
						array('order' => 'log_id desc')
					);
					$regist_log = $actionObj->db->pureSelectRow(
						'action_logs',
						NULL,
						'log_id<? and target=? and target_key=? and action=? and success=1',
						array($l['log_id'], 'box', $l['target_key'], 'create'),
						array('order' => 'log_id desc')
					);
					if ($regist_log)
						$regist_log_obj = unserialize($regist_log['detail']);
					$old_values = array();
					foreach ($obj as $prop => $value) {
						if ($prop == 'old_name')
							continue;
						$detected = FALSE;
						foreach ($old_logs as $old_log) {
							$d = @unserialize($old_log['detail']);
							if (empty($d))
								continue;
							if (array_key_exists($prop, $d)) {
								$detected = TRUE;
								$old_values[$prop] = array('id' => $old_log['log_id'], 'value' => $d[$prop]);
								break;
							}
						}
						if (! $detected) {
							if (! $regist_log) {
								$old_values[$prop] = '推測不可';
								continue;
							}
							$old_values[$prop] = array(
								'id' => $regist_log['log_id'],
								'value' => $regist_log_obj[$prop]
							);
						}
					}

					foreach ($old_values as $prop => $old_value) {
						if (is_string($old_value)) {
							echo h($prop).' の 以前の値は '.h($old_value);
						} else {
							if ($prop == 'script') {
								echo h($prop).' の 以前の値は (log: <a href="'.BASE_URL.'actiondetail/'.$old_value['id'].'/?back_url='.rawurlencode($back_url).'">'.$old_value['id'].'</a>)';
								echo '<pre>';
								echo h($old_value['value']);
								echo '</pre>';
							} else {
								echo h($prop).' の 以前の値は '.h($old_value['value']).' (log: <a href="'.BASE_URL.'actiondetail/'.$old_value['id'].'/?back_url='.rawurlencode($back_url).'">'.$old_value['id'].'</a>)';
							}
						}
						echo '<br/>';
					}
				}
			}
?>
			</div>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>