<?php
if (! can_action('operation'))
	redirect();

$o = array(
	'log_id' => '',
	'created' => '',
	'ip' => '',
	'id' => '',
	'user' => '',
	'target' => '',
	'action' => '',
	'target_id' => '',
	'target_key' => '',
	'success' => '',
	'detail' => ''
);
$params = array();
foreach ($o as $k => $v) {
	if (isset($_GET[$k])) {
		$o[$k] = $_GET[$k];
		$params[] = $k.'='.rawurlencode($_GET[$k]);
	}
}

$params = implode('&', $params);

require_once(LIB.'Action.class.php');
$actionObj = new Action();

$page = 1;
if (! empty($_GET['p']))
	$page = (int)$_GET['p'];
$show_count = 30;
$offset = ($page-1) * $show_count;

$logs = $actionObj->search($o, $offset.','.$show_count);
$cnt = $actionObj->count($o);

$full_url = BASE_URL.'actionlog/?p='.$page.'&'.$params;

$title = 'アクションログ';
$css_links = array('admin.css');
$script = <<<EOD
	$(function() {
		$("#log-table input[type='text']").tooltip()
	});
EOD;
include LAYOUTS.'header.inc.php';

$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>actionlog/">
			<input type="submit" value="検索" class="button" />
			<table id="log-table"><tbody>
				<tr>
					<th id="order-log_id">No</th>
					<th id="order-created">日時</th>
					<th id="order-ip">IP</th>
					<th id="order-id">ID</th>
					<th id="order-user">ユーザ</th>
					<th id="order-target">対象</th>
					<th id="order-action">行動</th>
					<th id="order-target_id">対象ID</th>
					<th id="order-target_key">対象詳細</th>
					<th id="order-success">成</th>
					<th id="order-detail">詳細</th>
				</tr>
				<tr>
					<td>
						<input type="text" name="log_id" value="<?php echo h($o['log_id']);?>" title="数値で入力してください。&lt;、&gt;、!=の3演算子が利用出来ます。" style="width:5ex" />
					</td>
					<td>
						<input type="text" name="created" value="<?php echo h($o['created']);?>" title="日付で入力してください。&lt;、&gt;、!=の3演算子が利用出来ます。" style="width:9em" />
					</td>
					<td>
						<input type="text" name="ip" value="<?php echo h($o['ip']);?>" title="前方一致文字列で指定してください。" style="width:8em" />
					</td>
					<td>
						<input type="text" name="id" value="<?php echo h($o['id']);?>" title="前方一致文字列で指定してください。" style="width:8ex" />
					</td>
					<td>
						<input type="text" name="user" value="<?php echo h($o['user']);?>" title="対象ユーザのログインIDまたは表示名を部分一致で指定してください。" style="width:8ex" />
					</td>
					<td>
						<input type="text" name="target" value="<?php echo h($o['target']);?>" title="前方一致文字列で指定してください。" style="width:6ex" />
					</td>
					<td>
						<input type="text" name="action" value="<?php echo h($o['action']);?>" title="前方一致文字列で指定してください。" style="width:6ex" />
					</td>
					<td>
						<input type="text" name="target_id" value="<?php echo h($o['target_id']);?>" title="数値で入力してください。&lt;、&gt;、!=の3演算子が利用出来ます。" style="width:4ex" />
					</td>
					<td>
						<input type="text" name="target_key" value="<?php echo h($o['target_key']);?>" title="前方一致文字列で指定してください。" style="width:12em" />
					</td>
					<td>
						<input type="text" name="success" value="<?php echo h($o['success']);?>" title="0が1で指定してください。" style="width:1em" />
					</td>
					<td>
						<input type="text" name="detail" value="<?php echo h($o['detail']);?>" title="部分一致文字列を入力してください。" style="width:10em" />
					</td>
				</tr>
				</form>
<?php
if (! empty($logs)) {
	foreach ($logs as $k => $l) {
		echo '<tr>';
		echo '<td><a href="'.BASE_URL.'actiondetail/'.$l['log_id'].'/?back_url='.rawurlencode($full_url).'">'.h($l['log_id']).'</a></td>';
		echo '<td>'.h($l['created']).'</td>';
		echo '<td>'.h($l['ip']).'</td>';
		echo '<td><a href="'.BASE_URL.'name/'.rawurlencode($l['id']).'">'.h($l['id']).'</a></td>';
		echo '<td><a href="'.BASE_URL.'user/'.rawurlencode($l['login_id']).'" title="'.h($l['display_name']).'">'.$l['login_id'].'</a></td>';
		echo '<td>'.h($l['target']).'</td>';
		echo '<td>'.h($l['action']).'</td>';

		echo '<td>';
		if ($l['target_id']) {
			if ($l['target'] == 'post') {
				echo '<a href="'.BASE_URL.'read/'.$l['target_id'].'">'.h($l['target_id']).'</a>';
			} else {
				echo h($l['target_id']);
			}
		} else {
			echo '-';
		}
		echo '</td>';

		echo '<td>';
		if ($l['target_key']) {
			if ($l['target'] == 'image') {
				echo '<a href="'.IMG_URL.$l['target_key'].'">'.h(mb_truncate($l['target_key'], 26)).'</a>';
			} else if ($l['target'] == 'url') {
				echo '<a href="'.$l['target_key'].'">'.h(mb_truncate($l['target_key'], 26)).'</a>';
			} else {
				echo h(mb_truncate($l['target_key'], 26));
			}
		} else {
			echo '-';
		}
		echo '</td>';

		echo '<td>'.($l['success'] ? '◆' : '').'</td>';

		echo '<td>';
		if ($l['detail']) {
			echo h(mb_truncate($l['detail'], 18));
		} else {
			echo '-';
		}
		echo '</td>';

		echo '</tr>';
	}
}
?>
			</tbody></table>
<?php
if (empty($logs)) {
			echo '<div>対象のログが見つかりません。</div>';
} else {
		print_paging_q(BASE_URL.'actionlog/?'.$params, $page, $show_count, $cnt);
}
?>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>