<?php
if (! can_action('operation'))
	redirect();

require_once(LIB.'Post.class.php');
$post = new Post();

$page = 1;
if (! empty($params[1]))
	$page = (int)$params[1];
$show_count = 50;
$offset = ($page-1) * $show_count;

$search = rawurldecode(@$params[0]);
if ($search) {
	$w = 'keyword like ?';
	$n = '%'.str_replace('%', '\\%', $search).'%';
	$params = array($n);
	$keywords = $post->getActiveKeyword($offset.','.$show_count, $w, $params);
	$cnt = $post->countActiveKeyword($w, $params);
} else {
	$keywords = $post->getActiveKeyword($offset.','.$show_count);
	$cnt = $post->countActiveKeyword();
}

$title = '最近言及されたキーワード一覧';
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead(true);
		$.each($(".time"), function() {
			$(this).text(T.countdown_by($(this).text()));
		});
		$("#search_form").submit(function() {
			location.href = $("#search_form").attr("action")+"/"+encodeURIComponent(encodeURIComponent($("#search").val()));
			return false;
		});
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box theme-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>active_keywords">
				<input type="text" name="search" id="search" value="<?php echo h($search);?>"  /> <input type="submit" value="検索" class="button" />
			</form>
		</div>

		<div class="controller-box theme-box">
			<div class="sub-box">
				<div id="recent_theme_container">
					<ul>
<?php
if (! empty($keywords)) {
	foreach ($keywords as $k => $v) {
		echo '<li><a href="'.BASE_URL.'keyword/'.rawurlencode($v['keyword']).'" class="name">'.h($v['keyword']).'('.$v['cnt'].')</a>'.($v['matched'] ? (' - <span class="time">'.$v['matched'].'</span>') : '').'</li>';
	}
}
?>
					</ul>
				</div>
			</div>
		</div>
<?php
	print_paging(BASE_URL.'active_keywords/'.$search, $page, $show_count, $cnt);
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>